/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.ListDataFlavor;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Iterator;
import java.util.List;

final class FileListDataType
extends DataType {
    static final ListDataFlavor<File> fileListFlavor = ListDataFlavor.newInstance("application/x-java-file-list");

    FileListDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        if (!this.isPresentedIn(transferable)) {
            return;
        }
        Object files = fileListFlavor.read(transferable);
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            dropData.addFile(this.toProtoFile(file));
        }
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsFiles(true);
    }

    @Override
    protected List<? extends RichDataFlavor<?>> supportedFlavors() {
        return ImmutableList.of(fileListFlavor);
    }

    private com.teamdev.jxbrowser.net.internal.rpc.File toProtoFile(File file) {
        return com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder().setFilePath(file.getAbsolutePath()).build();
    }
}

