/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.FilePathList;
import com.teamdev.jxbrowser.internal.rpc.OpenFiles;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public interface OpenFilesCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<OpenFiles.Response> {
        public Action(Consumer<OpenFiles.Response> consumer) {
            super(consumer);
        }

        public void open(Path ... filePaths) {
            Preconditions.checkNotNull(filePaths);
            FilePathList.Builder builder = FilePathList.newBuilder();
            Arrays.stream(filePaths).forEach(path -> builder.addFilePath(FilePath.newBuilder().setValue(path.toAbsolutePath().toString()).build()));
            this.send(OpenFiles.Response.newBuilder().setOpenFiles(builder.build()).build());
        }

        public void cancel() {
            this.send(OpenFiles.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public List<String> acceptableExtensions() {
            return ((OpenFiles.Request)this).getAcceptableExtensionList();
        }

        default public String filterDescription() {
            return ((OpenFiles.Request)this).getFilterDescription();
        }
    }
}

