/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.capture.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.capture.CaptureSession;
import com.teamdev.jxbrowser.capture.CaptureSource;
import com.teamdev.jxbrowser.capture.internal.CaptureSessionImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.rpc.CaptureSessionId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CaptureSessions
extends CloseableImpl {
    private final BrowserImpl browser;
    private final IdMap<CaptureSessionId, CaptureSessionImpl> captureSessions = new IdMap();

    public CaptureSessions(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
    }

    public void registerCaptureSession(CaptureSessionId id, CaptureSource source) {
        CaptureSessionImpl capture = new CaptureSessionImpl(this.browser, id, source);
        this.captureSessions.put(id, capture);
    }

    public void removeCaptureSession(CaptureSessionId id) {
        this.captureSessions.remove(id);
    }

    public List<CaptureSession> list() {
        this.checkNotClosed();
        return Collections.unmodifiableList(new ArrayList<CaptureSessionImpl>(this.captureSessions.values()));
    }

    @Override
    public void close() {
        this.captureSessions.values().forEach(CloseableImpl::close);
    }
}

