/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.event;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.dom.event.MouseEvent;
import com.teamdev.jxbrowser.dom.event.WheelEvent;
import com.teamdev.jxbrowser.dom.event.internal.rpc.MouseEventParams;
import com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;

public interface WheelEventParams
extends com.teamdev.jxbrowser.dom.event.MouseEventParams {
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    default public boolean isBubbles() {
        return this.mouseParams().getUiEventModifiersParams().isBubbles();
    }

    @Override
    default public boolean isTrusted() {
        return this.mouseParams().getUiEventModifiersParams().isTrusted();
    }

    @Override
    default public boolean isCancelable() {
        return this.mouseParams().getUiEventModifiersParams().isCancelable();
    }

    @Override
    default public Point clientLocation() {
        return this.mouseParams().getClientLocation();
    }

    @Override
    default public Point screenLocation() {
        return this.mouseParams().getScreenLocation();
    }

    @Override
    default public MouseEvent.Button button() {
        int button = this.mouseParams().getButton();
        return MouseEvent.Button.of(button);
    }

    @Override
    default public int clickCount() {
        return this.mouseParams().clickCount();
    }

    default public double deltaX() {
        return this.self().getDeltaX();
    }

    default public double deltaY() {
        return this.self().getDeltaY();
    }

    default public WheelEvent.DeltaMode deltaMode() {
        int number = this.self().getDeltaMode().getNumber();
        return WheelEvent.DeltaMode.of(number);
    }

    @Override
    default public KeyModifiers keyModifiers() {
        return this.mouseParams().keyModifiers();
    }

    default public com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams self() {
        return (com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams)this;
    }

    default public MouseEventParams mouseParams() {
        return this.self().getMouseParams();
    }

    public static final class Builder {
        private final WheelEventParams.Builder builder = com.teamdev.jxbrowser.dom.event.internal.rpc.WheelEventParams.newBuilder();

        private Builder() {
        }

        public Builder mouseEventParams(com.teamdev.jxbrowser.dom.event.MouseEventParams params) {
            Preconditions.checkNotNull(params);
            this.builder.setMouseParams((MouseEventParams)params);
            return this;
        }

        public Builder deltaX(double deltaX) {
            this.builder.setDeltaX(deltaX);
            return this;
        }

        public Builder deltaY(double deltaY) {
            this.builder.setDeltaY(deltaY);
            return this;
        }

        public Builder deltaMode(WheelEvent.DeltaMode mode) {
            Preconditions.checkNotNull(mode);
            this.builder.setDeltaMode(WheelEventParams.DeltaMode.forNumber(mode.mode()));
            return this;
        }

        public WheelEventParams build() {
            return this.builder.build();
        }
    }
}

