/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.FormControlElement;
import com.teamdev.jxbrowser.dom.FormElement;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.FormElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.GetActionRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetControlsRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetMethodRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetNameRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfoList;
import com.teamdev.jxbrowser.dom.internal.rpc.ResetRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SubmitRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Collections;
import java.util.List;

public final class FormElementImpl
extends ElementImpl
implements FormElement {
    private final ServiceConnectionImpl<FormElementStub> rpc;

    public static FormElementImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new FormElementImpl(connection, domContext, nodeInfo);
    }

    private FormElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<FormElementStub>(nodeInfo, connection, FormElementStub::new);
    }

    @Override
    public String action() {
        this.checkNotClosed();
        GetActionRequest request = GetActionRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getAction, request)).getValue();
    }

    @Override
    public String name() {
        this.checkNotClosed();
        GetNameRequest request = GetNameRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getName, request)).getValue();
    }

    @Override
    public String method() {
        this.checkNotClosed();
        GetMethodRequest request = GetMethodRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getMethod, request)).getValue();
    }

    @Override
    public void reset() {
        this.checkNotClosed();
        ResetRequest request = ResetRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::reset, request);
    }

    @Override
    public void submit() {
        this.checkNotClosed();
        SubmitRequest request = SubmitRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::submit, request);
    }

    @Override
    public List<FormControlElement> controls() {
        this.checkNotClosed();
        GetControlsRequest request = GetControlsRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getControls, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), FormControlElement.class));
    }
}

