/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class ProxyObjectValue
extends AbstractValue {
    ProxyObjectValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.OBJECT_PROXY_ID);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(Object.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: %s", type);
        JsContext context = JsContext.of(this.jsValue().getObjectProxyId().getPageContextId());
        return context.jsAccessibleObject(this.jsValue().getObjectProxyId()).map(JsAccessibleObject::object).orElse(null);
    }
}

