/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.rpc.JsSymbolId;
import com.teamdev.jxbrowser.js.JsSymbol;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsSymbolImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class SymbolValue
extends AbstractValue
implements JavaValue {
    SymbolValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.SYMBOL);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(JsSymbol.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: %s", type);
        JsSymbolId jsSymbolId = this.jsValue().getSymbol().getId();
        JsContext context = JsContext.of(jsSymbolId.getPageContextId());
        return (T)context.findJsSymbol(jsSymbolId).orElseGet(() -> {
            JsSymbolImpl symbol = new JsSymbolImpl(this.jsValue().getSymbol(), context);
            context.registerJsSymbol(symbol);
            return symbol;
        });
    }
}

