/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public enum BinariesListing {
    WIN32("chromium-win32.info"),
    WIN64("chromium-win64.info"),
    WIN64_ARM("chromium-win64-arm.info"),
    LINUX("chromium-linux64.info"),
    LINUX_ARM("chromium-linux64-arm.info"),
    MAC("chromium-mac.info"),
    MAC_ARM("chromium-mac-arm.info");

    private final String propertyFileName;

    private BinariesListing(String propertyFileName) {
        this.propertyFileName = propertyFileName;
    }

    public static List<BinariesListing> forCurrentPlatform() {
        ArrayList<BinariesListing> listings = new ArrayList<BinariesListing>();
        if (Environment.isMac()) {
            if (!Environment.isArm()) {
                listings.add(MAC);
            }
            listings.add(MAC_ARM);
        }
        if (Environment.isLinux()) {
            listings.add(Environment.isArm() ? LINUX_ARM : LINUX);
        }
        if (Environment.isWindows()) {
            if (Environment.isArm()) {
                listings.add(WIN64_ARM);
            } else {
                if (Environment.isWindows64()) {
                    listings.add(WIN64);
                }
                listings.add(WIN32);
            }
        }
        return listings.stream().filter(BinariesListing::exists).collect(ImmutableList.toImmutableList());
    }

    String propertyFileName() {
        return this.propertyFileName;
    }

    public boolean exists() {
        return this.resourceUrl() != null;
    }

    public List<ChromiumFile> files() {
        if (this.exists()) {
            Properties properties = this.asProperties();
            List<ChromiumFile> files = BinariesListing.getFiles(properties);
            return files;
        }
        return ImmutableList.of();
    }

    Properties asProperties() {
        URL resourceUrl = this.resourceUrl();
        Properties properties = new Properties();
        try (InputStream inputStream = resourceUrl.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load properties file:" + String.valueOf(resourceUrl), e);
        }
        return properties;
    }

    private static List<ChromiumFile> getFiles(Properties properties) {
        return properties.stringPropertyNames().stream().map(fileName -> {
            long fileLength = Long.parseLong(properties.getProperty((String)fileName));
            return new ChromiumFile((String)fileName, fileLength);
        }).collect(ImmutableList.toImmutableList());
    }

    private URL resourceUrl() {
        return BinariesListing.class.getResource(this.propertyFileName);
    }
}

