/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ChromiumLanguage;
import com.teamdev.jxbrowser.internal.ChromiumLocaleLinux;
import com.teamdev.jxbrowser.internal.ChromiumLocaleMac;
import com.teamdev.jxbrowser.internal.ChromiumLocaleWin;
import com.teamdev.jxbrowser.os.Environment;

abstract class ChromiumLocale {
    ChromiumLocale() {
    }

    static ChromiumLocale create() {
        if (Environment.isMac()) {
            return new ChromiumLocaleMac();
        }
        if (Environment.isWindows()) {
            return new ChromiumLocaleWin();
        }
        if (Environment.isLinux()) {
            return new ChromiumLocaleLinux();
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    abstract String localeSeparator();

    String localeLanguage(ChromiumLanguage chromiumLanguage) {
        Preconditions.checkNotNull(chromiumLanguage);
        StringBuilder localeLanguage = new StringBuilder();
        localeLanguage.append(chromiumLanguage.code());
        chromiumLanguage.country().ifPresent(country -> {
            localeLanguage.append(this.localeSeparator());
            localeLanguage.append((String)country);
        });
        return localeLanguage.toString();
    }
}

