/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ChromiumSwitch;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class ChromiumSwitches {
    private static final String SWITCH_PREFIX = "--";
    private static final String SWITCH_SEPARATOR = "=";
    private final List<ChromiumSwitch> switches = new ArrayList<ChromiumSwitch>();

    ChromiumSwitches() {
    }

    public void add(String name) {
        ChromiumSwitches.checkSwitchPart(name);
        this.switches.add(new ChromiumSwitch(name));
    }

    public void add(String name, Object value) {
        ChromiumSwitches.checkSwitchPart(name);
        ChromiumSwitches.checkSwitchPart(value);
        this.switches.add(new ChromiumSwitch(name, value));
    }

    public void addAll(Collection<String> args) {
        Preconditions.checkNotNull(args);
        args.forEach(s -> this.switches.add(ChromiumSwitch.of(s)));
    }

    public List<String> toList() {
        LinkedHashSet<String> enabledFeatures = new LinkedHashSet<String>();
        LinkedHashSet<String> disabledFeatures = new LinkedHashSet<String>();
        ArrayList<ChromiumSwitch> result = new ArrayList<ChromiumSwitch>();
        for (ChromiumSwitch chromiumSwitch : this.switches) {
            if (chromiumSwitch.name().equals("enable-features")) {
                enabledFeatures.addAll(chromiumSwitch.values());
                continue;
            }
            if (chromiumSwitch.name().equals("disable-features")) {
                disabledFeatures.addAll(chromiumSwitch.values());
                continue;
            }
            result.add(chromiumSwitch);
        }
        if (!enabledFeatures.isEmpty()) {
            result.add(new ChromiumSwitch("enable-features", String.join((CharSequence)",", enabledFeatures)));
        }
        if (!disabledFeatures.isEmpty()) {
            result.add(new ChromiumSwitch("disable-features", String.join((CharSequence)",", disabledFeatures)));
        }
        return result.stream().map(ChromiumSwitch::toString).collect(Collectors.toList());
    }

    private static void checkSwitchPart(Object part) {
        String strPart = Preconditions.checkNotNull(part).toString();
        StringPreconditions.checkNotNullEmptyOrBlank(strPart);
        Preconditions.checkArgument(!strPart.startsWith(SWITCH_PREFIX));
        Preconditions.checkArgument(!strPart.startsWith(SWITCH_SEPARATOR));
        Preconditions.checkArgument(!strPart.endsWith(SWITCH_SEPARATOR));
    }
}

