/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.internal.PrivilegedActions;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Path;

public abstract class JniLibrary {
    private static Path libraryPath;

    public static void path(Path path) {
        Preconditions.checkNotNull(path);
        libraryPath = path;
    }

    protected JniLibrary(JniLibraryName name) {
        Preconditions.checkState(libraryPath != null, "The library path has not been specified");
        PrivilegedActions.doPrivileged(() -> {
            Path path = libraryPath.toAbsolutePath().resolve(name.toPlatform());
            JniLibrary.loadLibrary(path);
        });
    }

    private static void loadLibrary(Path libraryPath) {
        if (Boolean.getBoolean("jxbrowser.jni.preload.enabled")) {
            return;
        }
        String fullPath = libraryPath.toFile().getAbsolutePath();
        System.load(fullPath);
        Logger.trace("Loaded library: `{0}`", fullPath);
    }
}

