/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.MessageOrBuilder;
import com.teamdev.jxbrowser.deps.com.google.protobuf.UnknownFieldSet;
import com.teamdev.jxbrowser.deps.com.google.protobuf.WireFormat;
import com.teamdev.jxbrowser.internal.rpc.OptionsProto;
import com.teamdev.jxbrowser.internal.rpc.TextFormatEscaper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class TextFormat {
    private static final int MAX_STR_LENGTH = 2048;
    private static final Printer PRINTER = new Printer();
    private static final String MASK = "*****";

    public static String shortDebugString(MessageOrBuilder message) {
        try {
            StringBuilder sb = new StringBuilder();
            PRINTER.print(message, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private TextFormat() {
    }

    private static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    private static String escapeBytes(ByteString input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    private static String toHex(int value) {
        return String.format((Locale)null, "0x%08x", value);
    }

    private static String toHex(long value) {
        return String.format((Locale)null, "0x%016x", value);
    }

    private static String escapeDoubleQuotesAndBackslashes(String input) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(input);
    }

    private static void printUnknownFieldValue(int tag, Object value, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value));
                break;
            }
            case 5: {
                generator.print(TextFormat.toHex((Integer)value));
                break;
            }
            case 1: {
                generator.print(TextFormat.toHex((Long)value));
                break;
            }
            case 2: {
                generator.print("\"");
                generator.print(TextFormat.escapeBytes((ByteString)value));
                generator.print("\"");
                break;
            }
            case 3: {
                PRINTER.printUnknownFields((UnknownFieldSet)value, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + tag);
            }
        }
    }

    private static boolean isSensitive(Descriptors.FieldDescriptor field) {
        boolean messageSensitive = field.getContainingType().getOptions().getExtension(OptionsProto.sensitiveMessage);
        boolean fieldSensitive = field.getOptions().getExtension(OptionsProto.sensitive);
        return messageSensitive || fieldSensitive;
    }

    private static final class Printer {
        private static final int MAX_PRINTABLE_REPEATED_FIELDS = 50;

        private Printer() {
        }

        private void print(MessageOrBuilder message, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
                this.printField(field.getKey(), field.getValue(), generator);
            }
            this.printUnknownFields(message.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            if (field.isRepeated()) {
                List items = (List)value;
                int printableFields = Math.min(items.size(), 50);
                for (int i = 0; i < printableFields; ++i) {
                    this.printSingleField(field, items.get(i), generator);
                }
                if (items.size() > 50) {
                    generator.print(String.format(" { %d... } ", items.size()));
                }
            } else {
                this.printSingleField(field, value, generator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field.isRequired() && !field.isRepeated() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(field.getMessageType().getFullName());
                } else {
                    generator.print(field.getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print(" { ");
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, value, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print("} ");
            } else {
                generator.print(" ");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            if (TextFormat.isSensitive(field)) {
                generator.print(TextFormat.MASK);
                String optionalSpace = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? " " : "";
                generator.print(optionalSpace);
                return;
            }
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value).toString());
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    generator.print(value.toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    Object string = (String)value;
                    if (((String)string).length() > 2048) {
                        string = ((String)string).substring(0, 2048) + "...";
                    }
                    generator.print(TextFormat.escapeDoubleQuotesAndBackslashes((String)string).replace("\n", "\\n"));
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value instanceof ByteString) {
                        ByteString byteString = (ByteString)value;
                        generator.print("[..." + byteString.size() + "]");
                    } else {
                        generator.print("[..." + ((byte[])value).length + "]");
                    }
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value, generator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filed type: " + String.valueOf((Object)field.getType()));
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(number, 0, field.getVarintList(), generator);
                this.printUnknownField(number, 5, field.getFixed32List(), generator);
                this.printUnknownField(number, 1, field.getFixed64List(), generator);
                this.printUnknownField(number, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value : field.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    generator.print(" { ");
                    this.printUnknownFields(value, generator);
                    generator.print("} ");
                }
            }
        }

        private void printUnknownField(int number, int wireType, List<?> values, TextGenerator generator) throws IOException {
            for (Object value : values) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value, generator);
                generator.print(" ");
            }
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable output) {
            this.output = output;
        }

        void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text.charAt(i) != '\n') continue;
                this.write(text.subSequence(pos, i + 1));
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos, size));
        }

        private void write(CharSequence data) throws IOException {
            if (data.isEmpty()) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }
}

