/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.UInt64Value;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.js.JsArray;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsArrayStub;
import com.teamdev.jxbrowser.js.internal.rpc.JsPropertyKey;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValues;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class JsArrayImpl
extends JsObjectImpl
implements JsArray {
    public static final long MAX_V8_ARRAY_SIZE = (long)(Math.pow(2.0, 32.0) - 1.0);
    public static final long MAX_ARRAY_SIZE = Integer.MAX_VALUE;
    public static final long MAX_ARRAY_INDEX = MAX_V8_ARRAY_SIZE - 1L;
    private final ServiceConnectionImpl<JsArrayStub> rpc;

    public JsArrayImpl(JsContext jsContext, JsObjectId jsObjectId) {
        super(jsContext, jsObjectId);
        this.rpc = new ServiceConnectionImpl<JsArrayStub>(this.objectId(), jsContext.connection(), JsArrayStub::new);
    }

    @Override
    public boolean set(long index, @Nullable Object value) {
        Preconditions.checkArgument(index >= 0L, "The index cannot be negative.");
        Preconditions.checkArgument(index <= MAX_ARRAY_INDEX, "The index cannot exceed the maximum array size.");
        this.checkNotClosed();
        return this.putProperty(JsPropertyKey.newBuilder().setIndex((int)index).build(), value);
    }

    @Override
    public <T> T get(long index) {
        this.checkNotClosed();
        Preconditions.checkArgument(index >= 0L, "The index cannot be negative.");
        Preconditions.checkArgument(index < this.length(), "The index cannot exceed the array size.");
        JavaValue value = this.getProperty(JsPropertyKey.newBuilder().setObjectId(this.objectId()).setIndex((int)index).build());
        return value.toReturnValue();
    }

    @Override
    public long length() {
        this.checkNotClosed();
        return ((UInt64Value)this.rpc.invoke(this.rpc.stub()::getLength, this.objectId())).getValue();
    }

    @Override
    public List<Object> toList() {
        this.checkNotClosed();
        long length = this.length();
        Preconditions.checkState(length <= Integer.MAX_VALUE, "The array size exceeds the maximum size of a list.");
        ArrayList list = new ArrayList((int)length);
        JsValues values = (JsValues)this.rpc.invoke(this.rpc.stub()::getItems, this.objectId());
        InputStream inputStream = values.getSerializedValues().newInput();
        try {
            while (inputStream.available() > 0) {
                JsValue jsValue = JsValue.parseDelimitedFrom(inputStream);
                list.add(JavaValue.from(jsValue).toObject());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert the array to list.", e);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public <T> List<T> toList(Class<T> type) {
        Preconditions.checkNotNull(type);
        this.checkNotClosed();
        long length = this.length();
        Preconditions.checkState(length <= Integer.MAX_VALUE, "The array size exceeds the maximum size of a list.");
        ArrayList list = new ArrayList((int)length);
        JsValues values = (JsValues)this.rpc.invoke(this.rpc.stub()::getItems, this.objectId());
        InputStream inputStream = values.getSerializedValues().newInput();
        try {
            while (inputStream.available() > 0) {
                JsValue jsValue = JsValue.parseDelimitedFrom(inputStream);
                list.add(JavaValue.from(jsValue).toObject(type));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert the array to list.", e);
        }
        return Collections.unmodifiableList(list);
    }
}

