/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.logging;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.logging.Level;
import com.teamdev.jxbrowser.logging.LoggerProvider;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class Logger {
    private static final java.util.logging.Logger log = LoggerProvider.logger();

    public static Level level() {
        return Level.valueOf(log.getLevel()).orElseThrow(() -> new IllegalStateException("Unsupported Java logging level: " + String.valueOf(log.getLevel())));
    }

    public static void level(Level level) {
        Preconditions.checkNotNull(level);
        log.setLevel(level.julLevel());
        for (Handler handler : log.getHandlers()) {
            handler.setLevel(level.julLevel());
        }
    }

    public static void off() {
        Logger.level(Level.OFF);
    }

    public static void error(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.ERROR.julLevel(), message);
    }

    public static void error(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.ERROR.julLevel(), message, arguments);
    }

    public static void error(String message, Throwable exception) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        log.log(Level.ERROR.julLevel(), message, exception);
    }

    public static void error(String message, Throwable exception, Supplier<String> parameterSupplier) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        Preconditions.checkNotNull(parameterSupplier);
        if (!Logger.isErrorEnabled()) {
            return;
        }
        LogRecord record = new LogRecord(Level.ERROR.julLevel(), message);
        record.setThrown(exception);
        record.setParameters(new Object[]{parameterSupplier.get()});
        log.log(record);
    }

    public static void error(String message, Throwable exception, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        Preconditions.checkNotNull(arguments);
        LogRecord record = new LogRecord(Level.ERROR.julLevel(), message);
        record.setThrown(exception);
        record.setParameters(arguments);
        log.log(record);
    }

    public static void info(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.INFO.julLevel(), message);
    }

    public static void info(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.INFO.julLevel(), message, arguments);
    }

    public static void warn(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.WARNING.julLevel(), message);
    }

    public static void warn(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.WARNING.julLevel(), message, arguments);
    }

    public static void warn(String message, Throwable exception) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        log.log(Level.WARNING.julLevel(), message, exception);
    }

    public static void warn(Throwable exception, Supplier<String> msgSupplier) {
        Preconditions.checkNotNull(exception);
        Preconditions.checkNotNull(msgSupplier);
        log.log(Level.WARNING.julLevel(), exception, msgSupplier);
    }

    public static void debug(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.DEBUG.julLevel(), message);
    }

    public static void debug(String message, Throwable exception) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        log.log(Level.DEBUG.julLevel(), message, exception);
    }

    public static void debug(Supplier<String> msgSupplier) {
        Preconditions.checkNotNull(msgSupplier);
        log.log(Level.DEBUG.julLevel(), msgSupplier);
    }

    public static void debug(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.DEBUG.julLevel(), message, arguments);
    }

    public static void debug(String message, Supplier<String> parameterSupplier) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(parameterSupplier);
        if (!Logger.isDebugEnabled()) {
            return;
        }
        LogRecord record = new LogRecord(Level.DEBUG.julLevel(), message);
        record.setParameters(new Object[]{parameterSupplier.get()});
        log.log(record);
    }

    public static void trace(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.TRACE.julLevel(), message, arguments);
    }

    public static void trace(Supplier<String> msgSupplier) {
        Preconditions.checkNotNull(msgSupplier);
        log.log(Level.TRACE.julLevel(), msgSupplier);
    }

    public static boolean isErrorEnabled() {
        return log.isLoggable(Level.ERROR.julLevel());
    }

    public static boolean isWarnEnabled() {
        return log.isLoggable(Level.WARNING.julLevel());
    }

    public static boolean isInfoEnabled() {
        return log.isLoggable(Level.INFO.julLevel());
    }

    public static boolean isDebugEnabled() {
        return log.isLoggable(Level.DEBUG.julLevel());
    }

    public static boolean isTraceEnabled() {
        return log.isLoggable(Level.TRACE.julLevel());
    }

    private Logger() {
    }
}

