/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.media.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.media.MediaDevice;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.media.callback.MediaCallback;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceList;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceManagerStub;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceType;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceTypeValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class MediaDevicesImpl
extends CloseableImpl
implements MediaDevices {
    private final EngineImpl engine;
    private final ServiceConnectionImpl<MediaDeviceManagerStub> rpc;

    public MediaDevicesImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.engine = engine;
        this.rpc = new ServiceConnectionImpl<MediaDeviceManagerStub>(engine.id(), engine.connection(), MediaDeviceManagerStub::new);
    }

    @Override
    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public List<MediaDevice> list(com.teamdev.jxbrowser.media.MediaDeviceType type) {
        this.checkNotClosed();
        MediaDeviceTypeValue request = MediaDeviceTypeValue.newBuilder().setMediaDeviceType(MediaDeviceType.fromPublic(type)).build();
        return Collections.unmodifiableList(((MediaDeviceList)this.rpc.invoke(this.rpc.stub()::getDevices, request)).getMediaDeviceList());
    }

    @Override
    public <C extends MediaCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((MediaCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends MediaCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends MediaCallback> C remove(Class<C> callbackClass) {
        return (C)((MediaCallback)this.rpc.remove(callbackClass));
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

