/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestJobId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobData;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobFactoryStub;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobOptions;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobStub;

public class UrlRequestJobImpl
extends CloseableImpl
implements UrlRequestJob {
    private final UrlRequestJobId id;
    private final ServiceConnectionImpl<UrlRequestJobStub> rpc;

    public static UrlRequestJobImpl create(UrlRequestJobOptions options, Connection connection) {
        Preconditions.checkNotNull(options);
        ServiceConnectionImpl<UrlRequestJobFactoryStub> rpc = new ServiceConnectionImpl<UrlRequestJobFactoryStub>(Protobuf.empty(), connection, UrlRequestJobFactoryStub::new);
        UrlRequestJobId urlRequestJobId = (UrlRequestJobId)rpc.invoke(((UrlRequestJobFactoryStub)rpc.stub())::createUrlRequestJob, options);
        return new UrlRequestJobImpl(urlRequestJobId, connection);
    }

    private UrlRequestJobImpl(UrlRequestJobId urlRequestJobId, Connection connection) {
        this.id = urlRequestJobId;
        this.rpc = new ServiceConnectionImpl<UrlRequestJobStub>(urlRequestJobId, connection, UrlRequestJobStub::new);
    }

    @Override
    public UrlRequestJob.Id id() {
        return this.id;
    }

    @Override
    public void write(byte[] data) {
        Preconditions.checkNotNull(data);
        this.checkNotClosed();
        UrlRequestJobData request = UrlRequestJobData.newBuilder().setUrlRequestJobId(this.id).setData(ByteString.copyFrom(data)).build();
        this.rpc.invoke(this.rpc.stub()::write, request);
    }

    @Override
    public void complete() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::complete, this.id);
        this.close();
    }

    @Override
    public void fail() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::fail, this.id);
        this.close();
    }
}

