/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.os.internal;

import com.teamdev.jxbrowser.browser.callback.internal.HideOnScreenKeyboardCallback;
import com.teamdev.jxbrowser.browser.callback.internal.ShowOnScreenKeyboardCallback;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.rpc.WindowHandle;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.os.internal.rpc.NotifyOnScreenKeyboardHiddenRequest;
import com.teamdev.jxbrowser.os.internal.rpc.NotifyOnScreenKeyboardShownRequest;
import com.teamdev.jxbrowser.os.internal.rpc.OnScreenKeyboardStub;
import java.util.concurrent.atomic.AtomicBoolean;

public class OnScreenKeyboard {
    private final ServiceConnectionImpl<OnScreenKeyboardStub> rpc;
    private final BrowserImpl browser;
    private final String uuid;
    private long requesterWindow;
    private long hostWindow;
    private Subscription focusGained;
    private Subscription focusLost;
    private final AtomicBoolean isChromiumFocused;

    public static boolean isEnabled() {
        return Environment.isWindows();
    }

    public void addNativeListeners(long windowHandle) {
        if (OnScreenKeyboard.isEnabled()) {
            this.hostWindow = windowHandle;
            ToolkitLibrary.instance().registerOnScreenKeyboardListener(windowHandle, this.uuid, this);
            this.rpc.set(ShowOnScreenKeyboardCallback.class, (params, tell) -> {
                this.requesterWindow = params.windowHandle().getValue();
                ToolkitLibrary.instance().showOnScreenKeyboard(this.hostWindow, tell::proceed);
            });
            this.rpc.set(HideOnScreenKeyboardCallback.class, (params, tell) -> {
                ToolkitLibrary.instance().hideOnScreenKeyboard(this.hostWindow);
                tell.proceed();
            });
            this.focusGained = this.browser.on(FocusGained.class, event -> this.isChromiumFocused.set(true));
            this.focusLost = this.browser.on(FocusLost.class, event -> this.isChromiumFocused.set(false));
        }
    }

    public void removeNativeListeners(long windowHandle) {
        if (OnScreenKeyboard.isEnabled()) {
            ToolkitLibrary.instance().unregisterOnScreenKeyboardListener(windowHandle, this.uuid);
            this.rpc.remove(HideOnScreenKeyboardCallback.class);
            this.rpc.remove(ShowOnScreenKeyboardCallback.class);
            if (this.focusGained != null) {
                this.focusGained.unsubscribe();
            }
            if (this.focusLost != null) {
                this.focusLost.unsubscribe();
            }
        }
    }

    public OnScreenKeyboard(BrowserImpl browser) {
        this.browser = browser;
        this.uuid = browser.id().getUuid();
        this.rpc = new ServiceConnectionImpl<OnScreenKeyboardStub>(browser.id(), browser.engine().connection(), OnScreenKeyboardStub::new);
        this.isChromiumFocused = new AtomicBoolean();
    }

    public void onShow(long windowHandle, int x, int y, int width, int height) {
        if (this.isChromiumFocused.get()) {
            NotifyOnScreenKeyboardShownRequest.Builder builder = NotifyOnScreenKeyboardShownRequest.newBuilder().setWindowHandle(WindowHandle.newBuilder().setValue(this.requesterWindow).build());
            this.rpc.invokeAsync(this.rpc.stub()::notifyOnScreenKeyboardShown, builder.build());
        }
    }

    public void onHide(long windowHandle) {
        if (this.isChromiumFocused.get()) {
            NotifyOnScreenKeyboardHiddenRequest.Builder builder = NotifyOnScreenKeyboardHiddenRequest.newBuilder().setWindowHandle(WindowHandle.newBuilder().setValue(this.requesterWindow));
            this.rpc.invokeAsync(this.rpc.stub()::notifyOnScreenKeyboardHidden, builder.build());
        }
    }
}

