/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.spellcheck.SanitationError;
import com.teamdev.jxbrowser.spellcheck.internal.SpellCheckerImpl;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.AddWordsRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.HasWordRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.RemoveWordsRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SanitationErrorList;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SpellCheckDictionaryStub;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.WordList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class DictionaryImpl
extends CloseableImpl
implements Dictionary {
    private final SpellCheckerImpl spellChecker;
    private final ServiceConnectionImpl<SpellCheckDictionaryStub> rpc;

    DictionaryImpl(SpellCheckerImpl spellChecker) {
        this.spellChecker = spellChecker;
        EngineImpl engine = spellChecker.profile().engine();
        this.rpc = new ServiceConnectionImpl<SpellCheckDictionaryStub>(engine.id(), engine.connection(), SpellCheckDictionaryStub::new);
    }

    @Override
    public Collection<String> words() {
        this.checkNotClosed();
        return ((WordList)this.rpc.invoke(this.rpc.stub()::getWords, this.spellChecker.profile().id())).getWordsList();
    }

    @Override
    public boolean add(String word) {
        StringPreconditions.checkNotNullEmptyOrBlank(word);
        return this.add(Set.of(word)).isEmpty();
    }

    @Override
    public List<SanitationError> add(Set<String> words) {
        this.checkNotClosed();
        Preconditions.checkNotNull(words);
        Preconditions.checkArgument(!words.isEmpty(), "The words set must not be empty.");
        return ((SanitationErrorList)this.rpc.invoke(this.rpc.stub()::addWords, AddWordsRequest.newBuilder().addAllWords(words).setProfileId(this.spellChecker.profile().id()).build())).getErrorsList().stream().map(error -> error).toList();
    }

    @Override
    public boolean remove(String word) {
        StringPreconditions.checkNotNullEmptyOrBlank(word);
        return this.remove(Set.of(word)).isEmpty();
    }

    @Override
    public List<SanitationError> remove(Set<String> words) {
        this.checkNotClosed();
        Preconditions.checkNotNull(words);
        Preconditions.checkArgument(!words.isEmpty(), "The words set must not be empty.");
        return ((SanitationErrorList)this.rpc.invoke(this.rpc.stub()::removeWords, RemoveWordsRequest.newBuilder().addAllWords(words).setProfileId(this.spellChecker.profile().id()).build())).getErrorsList().stream().map(error -> error).toList();
    }

    @Override
    public boolean has(String word) {
        StringPreconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasWord, HasWordRequest.newBuilder().setWord(StringValue.of(word)).setProfileId(this.spellChecker.profile().id()).build())).getValue();
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

