/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;

public interface Rect {
    public static Rect empty() {
        return Rect.of(Point.empty(), Size.empty());
    }

    public static Rect of(int width, int height) {
        Preconditions.checkArgument(width >= 0);
        Preconditions.checkArgument(height >= 0);
        return Rect.of(0, 0, width, height);
    }

    public static Rect of(int x, int y, int width, int height) {
        Preconditions.checkArgument(width >= 0);
        Preconditions.checkArgument(height >= 0);
        com.teamdev.jxbrowser.ui.internal.rpc.Point origin = com.teamdev.jxbrowser.ui.internal.rpc.Point.newBuilder().setX(x).setY(y).build();
        return com.teamdev.jxbrowser.ui.internal.rpc.Rect.newBuilder().setOrigin(origin).setSize((com.teamdev.jxbrowser.ui.internal.rpc.Size)Size.of(width, height)).build();
    }

    public static Rect of(Size size) {
        Preconditions.checkNotNull(size);
        return Rect.of(Point.empty(), size);
    }

    public static Rect of(Point origin, Size size) {
        Preconditions.checkNotNull(origin);
        Preconditions.checkNotNull(size);
        return Rect.of(origin.x(), origin.y(), size.width(), size.height());
    }

    default public Point origin() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Rect)this).getOrigin();
    }

    default public int x() {
        return this.origin().x();
    }

    default public int y() {
        return this.origin().y();
    }

    default public int width() {
        return this.size().width();
    }

    default public int height() {
        return this.size().height();
    }

    default public Point center() {
        int centerX = this.x() + this.width() / 2;
        int centerY = this.y() + this.height() / 2;
        return Point.of(centerX, centerY);
    }

    default public Size size() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Rect)this).getSize();
    }
}

