/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint;

public interface TouchPoint {
    public static Builder newBuilder(int id, Point screenPosition, TouchPoint.State state) {
        Preconditions.checkNotNull(screenPosition);
        Preconditions.checkNotNull(state);
        return new Builder(screenPosition, state, id);
    }

    default public int id() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getId();
    }

    default public double radiusX() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getRadiusX();
    }

    default public double radiusY() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getRadiusY();
    }

    default public double rotationAngle() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getRotationAngle();
    }

    default public Point positionInScreen() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getPositionInScreen();
    }

    default public Point positionInWidget() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getPositionInWidget();
    }

    default public double force() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.cast(this).getForce();
    }

    public static final class Builder {
        private final TouchPoint.Builder builder;

        private Builder(Point screenPosition, TouchPoint.State state, int id) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint.newBuilder().setPositionInScreen(com.teamdev.jxbrowser.ui.internal.rpc.Point.cast(screenPosition)).setState(state).setId(id);
        }

        public Builder force(float force) {
            this.builder.setForce(force);
            return this;
        }

        public Builder rotationAngle(float rotationAngle) {
            this.builder.setRotationAngle(rotationAngle);
            return this;
        }

        public Builder positionInWidget(Point widgetPosition) {
            Preconditions.checkNotNull(widgetPosition);
            this.builder.setPositionInWidget(com.teamdev.jxbrowser.ui.internal.rpc.Point.cast(widgetPosition));
            return this;
        }

        public Builder radiusX(float radiusX) {
            this.builder.setRadiusX(radiusX);
            return this;
        }

        public Builder radiusY(float radiusY) {
            this.builder.setRadiusY(radiusY);
            return this;
        }

        public TouchPoint build() {
            return this.builder.build();
        }
    }
}

