/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.user;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.user.internal.rpc.Address;

public interface Address {
    public static Builder newBuilder(String countryCode) {
        Preconditions.checkNotNull(countryCode);
        Preconditions.checkArgument(countryCode.length() == 2, "The country code must have 2 letters.");
        return new Builder(countryCode);
    }

    default public String streetAddress() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getStreetAddress();
    }

    default public String city() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getCity();
    }

    default public String dependentLocality() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getDependentLocality();
    }

    default public String state() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getState();
    }

    default public String zip() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getZipCode();
    }

    default public String countryCode() {
        return com.teamdev.jxbrowser.user.internal.rpc.Address.cast(this).getCountryCode();
    }

    public static final class Builder {
        private final Address.Builder builder;

        private Builder(String countryCode) {
            Preconditions.checkNotNull(countryCode);
            this.builder = com.teamdev.jxbrowser.user.internal.rpc.Address.newBuilder().setCountryCode(countryCode);
        }

        public Builder streetAddress(String address) {
            Preconditions.checkNotNull(address);
            this.builder.setStreetAddress(address);
            return this;
        }

        public Builder city(String city) {
            Preconditions.checkNotNull(city);
            this.builder.setCity(city);
            return this;
        }

        public Builder state(String state) {
            Preconditions.checkNotNull(state);
            this.builder.setState(state);
            return this;
        }

        public Builder zipCode(String zip) {
            Preconditions.checkNotNull(zip);
            this.builder.setZipCode(zip);
            return this;
        }

        public Builder dependentLocality(String dependentLocality) {
            Preconditions.checkNotNull(dependentLocality);
            this.builder.setDependentLocality(dependentLocality);
            return this;
        }

        public Address build() {
            return this.builder.build();
        }
    }
}

