/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.user;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.user.internal.rpc.Address;
import com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile;

public interface UserDataProfile {
    public static Builder newBuilder(com.teamdev.jxbrowser.user.Address address) {
        Preconditions.checkNotNull(address);
        return new Builder(address);
    }

    default public String fullName() {
        return com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(this).getFullName();
    }

    default public String email() {
        return com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(this).getEmail();
    }

    default public String companyName() {
        return com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(this).getCompany();
    }

    default public String phoneNumber() {
        return com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(this).getPhoneNumber();
    }

    default public com.teamdev.jxbrowser.user.Address address() {
        return com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(this).getAddress();
    }

    public static final class Builder {
        private final UserDataProfile.Builder builder;

        private Builder(com.teamdev.jxbrowser.user.Address address) {
            Preconditions.checkNotNull(address);
            this.builder = com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.newBuilder().setAddress(Address.cast(address));
        }

        public Builder fullName(String fullName) {
            Preconditions.checkNotNull(fullName);
            this.builder.setFullName(fullName);
            return this;
        }

        public Builder email(String email) {
            Preconditions.checkNotNull(email);
            this.builder.setEmail(email);
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Preconditions.checkNotNull(phoneNumber);
            this.builder.setPhoneNumber(phoneNumber);
            return this;
        }

        public Builder company(String company) {
            Preconditions.checkNotNull(company);
            this.builder.setCompany(company);
            return this;
        }

        public UserDataProfile build() {
            return this.builder.build();
        }
    }
}

