/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.user.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.user.UserDataProfile;
import com.teamdev.jxbrowser.user.UserDataProfiles;
import com.teamdev.jxbrowser.user.internal.rpc.AddUserDataProfile;
import com.teamdev.jxbrowser.user.internal.rpc.RemoveUserDataProfileRequest;
import com.teamdev.jxbrowser.user.internal.rpc.UserDataProfileList;
import com.teamdev.jxbrowser.user.internal.rpc.UserDataProfilesStub;
import java.util.List;

public final class UserDataProfilesImpl
extends CloseableImpl
implements UserDataProfiles {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<UserDataProfilesStub> rpc;

    public UserDataProfilesImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        Connection connection = profile.engine().connection();
        this.rpc = new ServiceConnectionImpl<UserDataProfilesStub>(profile.id(), connection, UserDataProfilesStub::new);
    }

    @Override
    public void add(UserDataProfile userDataProfile) {
        this.checkNotClosed();
        Preconditions.checkNotNull(userDataProfile);
        AddUserDataProfile addUserDataProfile = AddUserDataProfile.newBuilder().setUserDataProfile(com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile.cast(userDataProfile)).setProfileId(this.profile.id()).build();
        String error = ((StringValue)this.rpc.invoke(this.rpc.stub()::addProfile, addUserDataProfile)).getValue();
        if (!error.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public List<UserDataProfile> all() {
        this.checkNotClosed();
        return ((UserDataProfileList)this.rpc.invoke(this.rpc.stub()::getAllProfiles, this.profile.id())).getRecordList().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public void remove(UserDataProfile userDataProfile) {
        this.checkNotClosed();
        RemoveUserDataProfileRequest request = this.removeRecordRequest(((com.teamdev.jxbrowser.user.internal.rpc.UserDataProfile)userDataProfile).getGuid());
        this.rpc.invoke(this.rpc.stub()::removeProfile, request);
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::clear, this.profile.id());
    }

    private RemoveUserDataProfileRequest removeRecordRequest(String guid) {
        return RemoveUserDataProfileRequest.newBuilder().setProfileId(this.profile.id()).setGuid(guid).build();
    }
}

