/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.BrowserViewStateKt;
import com.teamdev.jxbrowser.view.compose.dnd.DragAndDropOptions;
import com.teamdev.jxbrowser.view.compose.internal.BrowserViewStates;
import com.teamdev.jxbrowser.view.compose.internal.CanvasWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.DefaultCallbacksKt;
import com.teamdev.jxbrowser.view.compose.internal.OffScreenWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.RenderWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.SharedSurfaceWidget;
import com.teamdev.jxbrowser.view.compose.internal.WindowedWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.components.dialogs.DialogState;
import com.teamdev.jxbrowser.view.compose.internal.components.menu.ContextMenuState;
import com.teamdev.jxbrowser.view.compose.internal.components.menu.SuggestionsPopupState;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ComposeDragAndDrop;
import com.teamdev.jxbrowser.view.compose.popup.PopupWindowState;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00060\u0002j\u0002`\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u00108\u001a\u000205H\u0002J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0002J\r\u0010<\u001a\u00020:H\u0000\u00a2\u0006\u0002\b=J\r\u0010>\u001a\u00020:H\u0000\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020:H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020+0&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u001c\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00100R\u0014\u00104\u001a\u000205X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006A"}, d2={"Lcom/teamdev/jxbrowser/view/compose/BrowserViewState;", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "browser", "Lcom/teamdev/jxbrowser/browser/Browser;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/teamdev/jxbrowser/browser/Browser;Lkotlinx/coroutines/CoroutineScope;Ljava/awt/Window;)V", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "kotlin.jvm.PlatformType", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "defaultCallbacks", "Lcom/teamdev/jxbrowser/callback/internal/DefaultCallbacks;", "Lcom/teamdev/jxbrowser/browser/callback/BrowserCallback;", "onBrowserClosed", "Lcom/teamdev/jxbrowser/event/Subscription;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_dragAndDropOptions", "Landroidx/compose/runtime/MutableState;", "Lcom/teamdev/jxbrowser/view/compose/dnd/DragAndDropOptions;", "value", "dragAndDropOptions", "getDragAndDropOptions", "()Lcom/teamdev/jxbrowser/view/compose/dnd/DragAndDropOptions;", "setDragAndDropOptions", "(Lcom/teamdev/jxbrowser/view/compose/dnd/DragAndDropOptions;)V", "alreadyInUse", "", "getAlreadyInUse$compose", "()Z", "setAlreadyInUse$compose", "(Z)V", "popups", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "Lcom/teamdev/jxbrowser/view/compose/popup/PopupWindowState;", "getPopups$compose", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "dialogs", "Lcom/teamdev/jxbrowser/view/compose/internal/components/dialogs/DialogState;", "getDialogs$compose", "contextMenu", "Lcom/teamdev/jxbrowser/view/compose/internal/components/menu/ContextMenuState;", "getContextMenu$compose", "()Landroidx/compose/runtime/MutableState;", "suggestionsPopup", "Lcom/teamdev/jxbrowser/view/compose/internal/components/menu/SuggestionsPopupState;", "getSuggestionsPopup$compose", "renderWidget", "Lcom/teamdev/jxbrowser/view/compose/internal/RenderWidgetState;", "getRenderWidget$compose", "()Lcom/teamdev/jxbrowser/view/compose/internal/RenderWidgetState;", "createRenderWidget", "verifyBrowserNotInUse", "", "logEnvironmentDetails", "enableDndSupport", "enableDndSupport$compose", "disableDndSupport", "disableDndSupport$compose", "close", "compose"})
@Stable
@SourceDebugExtension(value={"SMAP\nBrowserViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserViewState.kt\ncom/teamdev/jxbrowser/view/compose/BrowserViewState\n+ 2 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n+ 3 Browser.kt\ncom/teamdev/jxbrowser/dsl/browser/BrowserKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n78#2:318\n35#3:319\n1863#4,2:320\n1863#4,2:322\n*S KotlinDebug\n*F\n+ 1 BrowserViewState.kt\ncom/teamdev/jxbrowser/view/compose/BrowserViewState\n*L\n176#1:318\n182#1:319\n252#1:320,2\n253#1:322,2\n*E\n"})
public final class BrowserViewState
implements AutoCloseable {
    @NotNull
    private final Browser browser;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Window window;
    private final BrowserWidget widget;
    @NotNull
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    @NotNull
    private final Subscription onBrowserClosed;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final MutableState<DragAndDropOptions> _dragAndDropOptions;
    private boolean alreadyInUse;
    @NotNull
    private final SnapshotStateList<PopupWindowState> popups;
    @NotNull
    private final SnapshotStateList<DialogState> dialogs;
    @NotNull
    private final MutableState<ContextMenuState> contextMenu;
    @NotNull
    private final MutableState<SuggestionsPopupState> suggestionsPopup;
    @NotNull
    private final RenderWidgetState renderWidget;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public BrowserViewState(@NotNull Browser browser, @NotNull CoroutineScope scope, @NotNull Window window) {
        void $this$subscribe$iv;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.browser = browser;
        this.scope = scope;
        this.window = window;
        Browser browser2 = this.browser;
        Intrinsics.checkNotNull((Object)browser2, (String)"null cannot be cast to non-null type com.teamdev.jxbrowser.browser.internal.BrowserImpl");
        this.widget = ((BrowserImpl)browser2).widget();
        this.closed = new AtomicBoolean(false);
        this._dragAndDropOptions = SnapshotStateKt.mutableStateOf$default((Object)new DragAndDropOptions(false, false, 3, null), null, (int)2, null);
        this.popups = SnapshotStateKt.mutableStateListOf();
        this.dialogs = SnapshotStateKt.mutableStateListOf();
        this.contextMenu = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.suggestionsPopup = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.renderWidget = this.createRenderWidget();
        this.verifyBrowserNotInUse();
        this.logEnvironmentDetails();
        this.defaultCallbacks = BrowserViewStateKt.access$registerDefaultCallbacks(this.browser, arg_0 -> BrowserViewState._init_$lambda$0(this, arg_0));
        if (Environment.isLinux()) {
            this.widget.setForcedScaleFactor(1.0);
        }
        Observable observable = (Observable)this.browser;
        Observer observer$iv = arg_0 -> BrowserViewState._init_$lambda$1(this, arg_0);
        boolean $i$f$subscribe = false;
        Subscription subscription = $this$subscribe$iv.on(BrowserClosed.class, observer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"on(...)");
        this.onBrowserClosed = subscription;
    }

    @NotNull
    public final DragAndDropOptions getDragAndDropOptions() {
        return (DragAndDropOptions)this._dragAndDropOptions.getValue();
    }

    public final void setDragAndDropOptions(@NotNull DragAndDropOptions value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._dragAndDropOptions.setValue((Object)value);
    }

    public final boolean getAlreadyInUse$compose() {
        return this.alreadyInUse;
    }

    public final void setAlreadyInUse$compose(boolean bl) {
        this.alreadyInUse = bl;
    }

    @NotNull
    public final SnapshotStateList<PopupWindowState> getPopups$compose() {
        return this.popups;
    }

    @NotNull
    public final SnapshotStateList<DialogState> getDialogs$compose() {
        return this.dialogs;
    }

    @NotNull
    public final MutableState<ContextMenuState> getContextMenu$compose() {
        return this.contextMenu;
    }

    @NotNull
    public final MutableState<SuggestionsPopupState> getSuggestionsPopup$compose() {
        return this.suggestionsPopup;
    }

    @NotNull
    public final RenderWidgetState getRenderWidget$compose() {
        return this.renderWidget;
    }

    private final RenderWidgetState createRenderWidget() {
        Browser $this$renderingMode$iv = this.browser;
        boolean $i$f$getRenderingMode = false;
        RenderingMode renderingMode = $this$renderingMode$iv.engine().options().renderingMode();
        Intrinsics.checkNotNullExpressionValue((Object)renderingMode, (String)"renderingMode(...)");
        return switch (WhenMappings.$EnumSwitchMapping$0[renderingMode.ordinal()]) {
            case 1 -> {
                BrowserWidget v1 = this.widget;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"widget");
                yield new CanvasWidgetState(v1, this.scope, this.window);
            }
            case 2 -> {
                if (Environment.isMac()) {
                    BrowserWidget v3 = this.widget;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"widget");
                    yield new SharedSurfaceWidget(v3, this.scope, this.window);
                }
                if (Environment.isWindows() || Environment.isLinux()) {
                    BrowserWidget v4 = this.widget;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"widget");
                    yield new WindowedWidgetState(v4, this.scope, this.window);
                }
                throw new IllegalStateException("Unsupported operating system.".toString());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void verifyBrowserNotInUse() {
        if (BrowserViewStates.INSTANCE.get(this.browser) != null) {
            throw new IllegalStateException("The `Browser` instance is already used by another state instance.  Use another browser instance or close the state that is using this one.".toString());
        }
        BrowserViewStates.INSTANCE.put(this.browser, this);
    }

    private final void logEnvironmentDetails() {
        Logger.debug((String)"UI Toolkit: Compose");
        boolean useNativeInput = Boolean.getBoolean("jxbrowser.native.input.enabled");
        Logger.debug((String)("Input method: " + (useNativeInput ? "Native" : "Java")));
    }

    public final void enableDndSupport$compose() {
        DragAndDrop dragAndDrop;
        DragAndDropOptions $this$enableDndSupport_u24lambda_u243 = this.getDragAndDropOptions();
        boolean bl = false;
        Browser browser = this.browser;
        Intrinsics.checkNotNull((Object)browser, (String)"null cannot be cast to non-null type com.teamdev.jxbrowser.browser.internal.BrowserImpl");
        DragAndDrop $this$enableDndSupport_u24lambda_u243_u24lambda_u242 = dragAndDrop = ((BrowserImpl)browser).dragAndDrop();
        boolean bl2 = false;
        if ($this$enableDndSupport_u24lambda_u243.getDragAndDropEnabled()) {
            $this$enableDndSupport_u24lambda_u243_u24lambda_u242.enable();
        } else {
            $this$enableDndSupport_u24lambda_u243_u24lambda_u242.disable();
        }
        if ($this$enableDndSupport_u24lambda_u243.getExternalDragEnabled()) {
            $this$enableDndSupport_u24lambda_u243_u24lambda_u242.enableExternalDrag();
        } else {
            $this$enableDndSupport_u24lambda_u243_u24lambda_u242.disableExternalDrag();
        }
        if (this.renderWidget instanceof OffScreenWidgetState && ComposeDragAndDrop.INSTANCE.isSupported()) {
            ((OffScreenWidgetState)this.renderWidget).enableDndSupport($this$enableDndSupport_u24lambda_u243);
        }
    }

    public final void disableDndSupport$compose() {
        if (this.renderWidget instanceof OffScreenWidgetState) {
            ((OffScreenWidgetState)this.renderWidget).disableDndSupport();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object it;
            BrowserViewStates.INSTANCE.remove(this.browser);
            this.defaultCallbacks.unregister();
            this.onBrowserClosed.unsubscribe();
            Iterable $this$forEach$iv = this.popups.toList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PopupWindowState)element$iv;
                boolean bl = false;
                ((PopupWindowState)it).close();
            }
            $this$forEach$iv = this.dialogs.toList();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DialogState)element$iv;
                boolean bl = false;
                it.close();
            }
            ContextMenuState contextMenuState = (ContextMenuState)this.contextMenu.getValue();
            if (contextMenuState != null) {
                contextMenuState.close();
            }
            SuggestionsPopupState suggestionsPopupState = (SuggestionsPopupState)this.suggestionsPopup.getValue();
            if (suggestionsPopupState != null) {
                suggestionsPopupState.cancel();
            }
            this.renderWidget.close();
        }
    }

    private static final Unit _init_$lambda$0(BrowserViewState this$0, DefaultCallbacks.Builder $this$registerDefaultCallbacks) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$registerDefaultCallbacks, (String)"$this$registerDefaultCallbacks");
        DefaultCallbacksKt.webDialogCallbacks((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks);
        DefaultCallbacksKt.fileChooserCallbacks((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks, this$0.window);
        DefaultCallbacksKt.popupCallbacks((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks, this$0.scope, this$0.popups, (State<DragAndDropOptions>)((State)this$0._dragAndDropOptions));
        DefaultCallbacksKt.optionDialogCallbacks((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks, this$0.scope, this$0.dialogs);
        DefaultCallbacksKt.menuCallbacks((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks, this$0.scope, this$0.browser, this$0.contextMenu, this$0.suggestionsPopup);
        DefaultCallbacksKt.showTextReplacementCallback((DefaultCallbacks.Builder<BrowserCallback>)$this$registerDefaultCallbacks, this$0.window);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(BrowserViewState this$0, BrowserClosed it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.close();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenderingMode.values().length];
            try {
                nArray[RenderingMode.OFF_SCREEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderingMode.HARDWARE_ACCELERATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

