/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.MimeType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.StringDataFlavor;
import com.teamdev.jxbrowser.view.compose.internal.dnd.UrlDataTypeKt;
import java.awt.datatransfer.Transferable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/UrlDataType;", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DataType;", "<init>", "()V", "fillDropData", "", "dropData", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropData$Builder;", "transferable", "Ljava/awt/datatransfer/Transferable;", "fillMetadata", "metadata", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DropMetadata$Builder;", "extractUrl", "", "rawString", "supportedFlavors", "", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor;", "Companion", "compose"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nUrlDataType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlDataType.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/UrlDataType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n295#2,2:58\n*S KotlinDebug\n*F\n+ 1 UrlDataType.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/UrlDataType\n*L\n37#1:58,2\n*E\n"})
public final class UrlDataType
extends DataType {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Deprecated
    @NotNull
    public static final String CRLF = "\r\n";
    @Deprecated
    @NotNull
    public static final String LF = "\n";
    @NotNull
    private static final StringDataFlavor URI_LIST;
    @NotNull
    private static final StringDataFlavor JAVA_URL;
    @NotNull
    private static final StringDataFlavor MOZ_URL;

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillDropData(@NotNull DropData.Builder dropData, @NotNull Transferable transferable) {
        block3: {
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)dropData, (String)"dropData");
                Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
                if (Environment.isMac() && UrlDataTypeKt.access$hasFiles(transferable)) {
                    return;
                }
                Iterable iterable = this.supportedFlavors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    StringDataFlavor it = (StringDataFlavor)element$iv;
                    boolean bl = false;
                    if (!it.isPresentedIn(transferable)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            StringDataFlavor stringDataFlavor = v0;
            if (stringDataFlavor == null) break block3;
            StringDataFlavor it = stringDataFlavor;
            boolean bl = false;
            String url = this.extractUrl(it.read(transferable));
            dropData.setUrl(url);
        }
    }

    @Override
    protected void fillMetadata(@NotNull DropMetadata.Builder metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        metadata.setContainsUrl(true);
    }

    private final String extractUrl(String rawString) {
        String separator = StringsKt.contains$default((CharSequence)rawString, (CharSequence)CRLF, (boolean)false, (int)2, null) ? CRLF : LF;
        String[] stringArray = new String[]{separator};
        return (String)StringsKt.split$default((CharSequence)rawString, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    @NotNull
    protected List<StringDataFlavor> supportedFlavors() {
        Object[] objectArray = new StringDataFlavor[]{URI_LIST, JAVA_URL, MOZ_URL};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        URI_LIST = new StringDataFlavor(new MimeType("text/uri-list"), null, 2, null);
        JAVA_URL = new StringDataFlavor(new MimeType("application/x-java-url"), null, 2, null);
        MimeType mimeType = new MimeType("text/x-moz-url");
        Charset charset = StandardCharsets.UTF_16LE;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
        MOZ_URL = new StringDataFlavor(mimeType, charset);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/UrlDataType$Companion;", "", "<init>", "()V", "CRLF", "", "LF", "URI_LIST", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor;", "getURI_LIST", "()Lcom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor;", "JAVA_URL", "getJAVA_URL", "MOZ_URL", "getMOZ_URL", "compose"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringDataFlavor getURI_LIST() {
            return URI_LIST;
        }

        @NotNull
        public final StringDataFlavor getJAVA_URL() {
            return JAVA_URL;
        }

        @NotNull
        public final StringDataFlavor getMOZ_URL() {
            return MOZ_URL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

