/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ScaleFactor;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import java.util.function.Consumer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Shell;

class DisplayWatcher
extends com.teamdev.jxbrowser.internal.DisplayWatcher<NativeAwareControl> {
    private final ShellListener shellListener = new ShellListener();
    private Shell shell;
    private long windowHandle;
    private boolean attached = false;

    private DisplayWatcher(Consumer<Display> observer) {
        super(observer);
    }

    static DisplayWatcher newInstance(Consumer<Display> observer) {
        Preconditions.checkNotNull(observer);
        if (HeadlessToolkits.isHeadlessToolkit()) {
            return new NopDisplayWatcher();
        }
        return new DisplayWatcher(observer);
    }

    private void notifyControlStateChanged() {
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.instance();
        String displayId = toolkitLibrary.getDisplayIdForWindow(this.windowHandle);
        double scaleFactor = ScaleFactor.forDisplay((String)displayId);
        this.changeDisplay(Display.newInstance((String)displayId, (double)scaleFactor));
    }

    public void attach(NativeAwareControl control) {
        Preconditions.checkNotNull((Object)control);
        if (Environment.isLinux()) {
            return;
        }
        this.shell = control.getShell();
        if (this.shell == null) {
            return;
        }
        long windowHandle = control.nativeHandle();
        if (this.attached) {
            if (windowHandle != this.windowHandle) {
                throw this.cannotAttach(windowHandle);
            }
            return;
        }
        this.shell.addControlListener((ControlListener)this.shellListener);
        this.windowHandle = windowHandle;
        this.notifyControlStateChanged();
        this.attached = true;
    }

    public void detach() {
        if (Environment.isLinux()) {
            return;
        }
        if (!this.attached) {
            return;
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.removeControlListener((ControlListener)this.shellListener);
        }
        this.attached = false;
    }

    private IllegalStateException cannotAttach(long windowHandle) {
        throw new IllegalStateException(String.format("Failed to attach to the handle `%d` due to being attached to the other handle: `%d`. Make sure to call detach() first.", windowHandle, this.windowHandle));
    }

    private class ShellListener
    extends ControlAdapter {
        private ShellListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            DisplayWatcher.this.notifyControlStateChanged();
        }

        public void controlMoved(ControlEvent e) {
            DisplayWatcher.this.notifyControlStateChanged();
        }
    }

    private static final class NopDisplayWatcher
    extends DisplayWatcher {
        private NopDisplayWatcher() {
            super(display -> {});
        }

        @Override
        public void attach(NativeAwareControl control) {
        }

        @Override
        public void detach() {
        }
    }
}

