/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.EclipseWorkbenchDetector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

final class EclipsePartVisibilityTracker {
    private final BrowserComposite browserComposite;
    private final Listener showListener;
    private final Listener hideListener;
    private Composite contributedPartRenderer;

    private EclipsePartVisibilityTracker(BrowserComposite composite, Listener showListener, Listener hideListener) {
        this.browserComposite = composite;
        this.showListener = showListener;
        this.hideListener = hideListener;
    }

    static Builder newBuilder(BrowserComposite browserComposite) {
        return new Builder(browserComposite);
    }

    void start() {
        EclipseWorkbenchDetector.findContributedPartRenderer((Composite)this.browserComposite).ifPresent(partRenderer -> {
            this.contributedPartRenderer = partRenderer;
            partRenderer.addListener(22, this.showListener);
            partRenderer.addListener(23, this.hideListener);
        });
    }

    void stop() {
        if (this.contributedPartRenderer != null && !this.contributedPartRenderer.isDisposed()) {
            this.contributedPartRenderer.removeListener(22, this.showListener);
            this.contributedPartRenderer.removeListener(23, this.hideListener);
        }
    }

    void reattach() {
        this.stop();
        this.start();
    }

    static class Builder {
        private final BrowserComposite browserComposite;
        private Listener showListener;
        private Listener hideListener;

        Builder(BrowserComposite browserComposite) {
            Preconditions.checkNotNull((Object)((Object)browserComposite));
            this.browserComposite = browserComposite;
        }

        Builder showListener(Listener showListener) {
            Preconditions.checkNotNull((Object)showListener);
            this.showListener = showListener;
            return this;
        }

        Builder hideListener(Listener hideListener) {
            Preconditions.checkNotNull((Object)hideListener);
            this.hideListener = hideListener;
            return this;
        }

        EclipsePartVisibilityTracker build() {
            Preconditions.checkNotNull((Object)this.showListener);
            Preconditions.checkNotNull((Object)this.hideListener);
            return new EclipsePartVisibilityTracker(this.browserComposite, this.showListener, this.hideListener);
        }
    }
}

