/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.deps.com.google.common.util.concurrent.Uninterruptibles;
import com.teamdev.jxbrowser.view.swt.internal.FocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibrary;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class LinuxFocusAdapter
extends FocusAdapter {
    private static final Duration CONCURRENT_FOCUS_TIMEOUT = Duration.ofMillis(300L);
    private static final String ECLIPSE_PART_RENDERER = "ContributedPartRenderer";
    private final AtomicBoolean ignoreNextFocusGained = new AtomicBoolean();
    private final AtomicBoolean ignoreNextFocusIn = new AtomicBoolean();
    private final AtomicBoolean widgetBeingManuallyFocused = new AtomicBoolean();
    private final AtomicBoolean canRestoreSwtFocus = new AtomicBoolean(true);

    LinuxFocusAdapter(WindowedWidget widget) {
        super(widget);
    }

    @Override
    protected void on(FocusGained event) {
        LastFocusEvent.focusGained();
        this.ignoreNextFocusIn.set(true);
        WindowedWidget jxComposite = this.windowedWidget();
        if (!this.ignoreNextFocusGained.get()) {
            SafeExecutor.asyncExec((Widget)jxComposite, () -> {
                this.widgetBeingManuallyFocused.set(true);
                jxComposite.setFocus();
                this.widgetBeingManuallyFocused.set(false);
            });
        }
        this.ignoreNextFocusGained.set(false);
    }

    @Override
    protected void on(FocusLost event) {
        LastFocusEvent.focusLost();
        this.ignoreNextFocusIn.set(false);
    }

    @Override
    protected void onSwtWidgetFocusedIn(Event event) {
        WindowedWidget jxComposite = this.windowedWidget();
        if (jxComposite.isDisposed()) {
            return;
        }
        if (this.widgetBeingManuallyFocused.get() && event.widget != jxComposite) {
            this.canRestoreSwtFocus.set(true);
            this.ignoreNextFocusIn.set(true);
            if (LinuxFocusAdapter.isEclipsePart(event.widget)) {
                SafeExecutor.asyncExec((Widget)jxComposite, () -> ((WindowedWidget)jxComposite).setFocus());
            }
            return;
        }
        if (event.widget == jxComposite) {
            if (!this.ignoreNextFocusIn.get()) {
                this.ifNoConcurrentFocus(() -> {
                    this.ignoreNextFocusGained.set(true);
                    jxComposite.focusBrowserWidget();
                });
            }
            this.ignoreNextFocusIn.set(false);
        } else if (this.canRestoreSwtFocus.get() && this.fromSameShell(event.widget, jxComposite) && this.isNotJxBrowser(event)) {
            this.focusSwtWindow();
        }
        this.canRestoreSwtFocus.set(jxComposite == event.widget);
    }

    private void ifNoConcurrentFocus(Runnable runnable) {
        new Thread(() -> {
            Uninterruptibles.sleepUninterruptibly((Duration)CONCURRENT_FOCUS_TIMEOUT);
            SafeExecutor.asyncExec((Widget)this.windowedWidget(), () -> {
                boolean noConcurrentChromiumFocus;
                boolean noConcurrentSwtFocus = this.isFocusHolder();
                if (noConcurrentSwtFocus && (noConcurrentChromiumFocus = LastFocusEvent.isFocusLost())) {
                    runnable.run();
                }
            });
        }).start();
    }

    private boolean isFocusHolder() {
        WindowedWidget jxComposite = this.windowedWidget();
        return jxComposite.getDisplay().getFocusControl() == jxComposite;
    }

    private boolean isNotJxBrowser(Event event) {
        return !(event.widget instanceof WindowedWidget);
    }

    private boolean fromSameShell(Widget widget, WindowedWidget jxComposite) {
        if (widget instanceof Control) {
            Control control = (Control)widget;
            return jxComposite.getShell() == control.getShell();
        }
        throw new IllegalStateException("Unexpected type of SWT widget.");
    }

    private void focusSwtWindow() {
        Shell shell = this.windowedWidget().getShell();
        GtkLibrary.instance().focusWindow(shell);
    }

    private static boolean isEclipsePart(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        return widgetClass.isAnonymousClass() && widgetClass.getEnclosingClass().getSimpleName().equals(ECLIPSE_PART_RENDERER);
    }

    private static enum LastFocusEvent {
        INSTANCE;

        private final AtomicBoolean focusGained = new AtomicBoolean();

        static void focusGained() {
            LastFocusEvent.INSTANCE.focusGained.set(true);
        }

        static void focusLost() {
            LastFocusEvent.INSTANCE.focusGained.set(false);
        }

        static boolean isFocusLost() {
            return !LastFocusEvent.INSTANCE.focusGained.get();
        }
    }
}

