/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragImage;
import java.util.Optional;

public final class BrowserDragContext {
    private CurrentDragOperation dragOperation;
    private boolean externalDragEnabled = true;

    static BrowserDragContext newInstance() {
        return new BrowserDragContext();
    }

    private BrowserDragContext() {
    }

    void browserDragOperation(DropData dropData, DragImage dragImage) {
        Preconditions.checkNotNull((Object)dropData);
        Preconditions.checkNotNull((Object)dragImage);
        this.dragOperation = new CurrentDragOperation(dragImage, dropData);
    }

    Optional<CurrentDragOperation> browserDragOperation() {
        return Optional.ofNullable(this.dragOperation);
    }

    void resetBrowserDragOperation() {
        this.dragOperation = null;
    }

    public void setEnabledExternalDrag(boolean enabled) {
        this.externalDragEnabled = enabled;
    }

    boolean isExternalDragEnabled() {
        return this.externalDragEnabled;
    }

    static class CurrentDragOperation {
        private final DragImage dragImage;
        private final DropData dropData;

        private CurrentDragOperation(DragImage dragImage, DropData dropData) {
            this.dragImage = dragImage;
            this.dropData = dropData;
        }

        DragImage dragImage() {
            return this.dragImage;
        }

        DropData dropData() {
            return this.dropData;
        }
    }
}

