/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.dnd.CustomDataTransfer;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DataType;
import org.eclipse.swt.dnd.TransferData;

final class CustomDataType
extends DataType<CustomDataTransfer, byte[]> {
    CustomDataType() {
        super(CustomDataTransfer.getInstance());
    }

    @Override
    void fillDropData(TransferData transferData, DropData.Builder dropData) {
        CustomDataTransfer transfer = (CustomDataTransfer)((Object)this.transfer());
        if (Environment.isMac()) {
            byte[] data = MacPasteboard.instance().readCustomData();
            if (data.length > 0) {
                DropData.CustomData customData = this.customData(ByteString.copyFrom((byte[])data));
                dropData.setCustomData(customData);
            }
        } else {
            byte[] data = transfer.fromNative(transferData);
            if (data != null) {
                DropData.CustomData customData = DropData.CustomData.newBuilder().setAsBytes(ByteString.copyFrom((byte[])data)).build();
                dropData.setCustomData(customData);
            }
        }
    }

    @Override
    protected void fillMetadata(DropMetadata.Builder metadata) {
    }

    @Override
    byte[] read(DropData dropData) {
        return dropData.getCustomData().getAsBytes().toByteArray();
    }

    @Override
    boolean isPresentedIn(DropData dropData) {
        return !dropData.getCustomData().getAsBytes().isEmpty();
    }

    private DropData.CustomData customData(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }
}

