/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback;

import com.teamdev.jxbrowser.browser.callback.OpenFileCallback;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

public final class DefaultOpenFileCallback
extends DefaultCallback
implements OpenFileCallback {
    public DefaultOpenFileCallback(BrowserView parent) {
        super(parent);
    }

    public void on(OpenFileCallback.Params params, OpenFileCallback.Action tell) {
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            String filePath;
            FileDialog dialog = new FileDialog(((BrowserView)((Object)((Object)this.widget()))).getShell(), 4096);
            dialog.setText(params.filterDescription());
            StringBuilder builder = new StringBuilder();
            params.acceptableExtensions().forEach(extension -> builder.append("*.").append((String)extension).append(';'));
            ArrayList<String> extensions = new ArrayList<String>();
            extensions.add(builder.toString());
            if (params.acceptAll()) {
                extensions.add("*.*");
            }
            dialog.setFilterExtensions(extensions.toArray(new String[0]));
            if (!params.suggestedDirectory().isEmpty()) {
                dialog.setFilterPath(params.suggestedDirectory());
            }
            if ((filePath = dialog.open()) != null) {
                tell.open(Paths.get(filePath, new String[0]));
            } else {
                tell.cancel();
            }
        }, () -> ((OpenFileCallback.Action)tell).cancel());
    }
}

