/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class OpenBrowserPopupCallback
extends DefaultCallback {
    protected static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);
    private org.eclipse.swt.graphics.Point latestSize = new org.eclipse.swt.graphics.Point(0, 0);

    public OpenBrowserPopupCallback(BrowserView parent) {
        super(parent);
    }

    protected void integrate(Browser browser, Rect initialBounds) {
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            Display display = ((BrowserView)((Object)((Object)this.widget()))).getDisplay();
            Shell shell = new Shell(display, this.shellParams());
            shell.setLayout((Layout)new FillLayout());
            BrowserView view = BrowserView.newInstance((Composite)shell, browser);
            OpenBrowserPopupCallback.updateOrigin(shell, initialBounds.origin());
            this.updateSize(shell, view, initialBounds.size());
            shell.addDisposeListener(event -> {
                if (!browser.isClosed()) {
                    SafeExecutor.asyncExec((Widget)this.widget(), () -> ((Browser)browser).close());
                }
            });
            browser.on(TitleChanged.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> shell.setText(event.title())));
            browser.on(BrowserClosed.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> ((Shell)shell).dispose()));
            browser.on(UpdateBoundsRequested.class, event -> this.updateBounds((UpdateBoundsRequested)event, shell, view));
            view.setVisible(true);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
    }

    protected int shellParams() {
        return 2144;
    }

    private void updateBounds(UpdateBoundsRequested event, Shell shell, BrowserView view) {
        SafeExecutor.asyncExec((Widget)shell, () -> {
            Rect popupBounds = event.bounds();
            Size newSize = popupBounds.size();
            if (!OpenBrowserPopupCallback.currentSize(view).equals((Object)newSize)) {
                this.updateSize(shell, view, newSize);
            }
            Point newOrigin = popupBounds.origin();
            if (!OpenBrowserPopupCallback.currentOrigin(view).equals((Object)newOrigin)) {
                OpenBrowserPopupCallback.updateOrigin(shell, newOrigin);
            }
        });
    }

    private static Point currentOrigin(BrowserView view) {
        org.eclipse.swt.graphics.Point viewLocation = view.toDisplay(0, 0);
        return Geometry.newPoint((double)viewLocation.x, (double)viewLocation.y);
    }

    private static Size currentSize(BrowserView view) {
        org.eclipse.swt.graphics.Point boundsInLocal = view.getSize();
        return Size.of((int)boundsInLocal.x, (int)boundsInLocal.y);
    }

    private static void updateOrigin(Shell shell, Point newOrigin) {
        shell.setLocation(newOrigin.x(), newOrigin.y());
    }

    private void updateSize(Shell shell, BrowserView view, Size newSize) {
        if (newSize.isEmpty()) {
            view.setSize(DEFAULT_POPUP_SIZE.width(), DEFAULT_POPUP_SIZE.height());
        } else {
            view.setSize(newSize.width(), newSize.height());
        }
        org.eclipse.swt.graphics.Point newPreferredSize = shell.computeSize(-1, -1, true);
        if (newPreferredSize.equals((Object)this.latestSize)) {
            return;
        }
        this.latestSize = newPreferredSize;
        shell.setSize(newPreferredSize);
    }
}

