/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.PaintWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swt.internal.GraphicsRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.platform.HiDpi;
import com.teamdev.jxbrowser.view.swt.internal.platform.NativeWindow;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

final class GraphicsWebDialogView
extends Composite
implements NativeAwareControl {
    private final OffScreenRenderWidget parent;
    private final KeyListener keyListener;
    private final MouseListener mouseListener;
    private final MouseMotionListener mouseMoveListener;
    private final MouseTrackListener mouseTrackListener;
    private final MouseVerticalWheelListener mouseVerticalWheelListener;
    private final MouseHorizontalWheelListener mouseHorizontalWheelListener;

    GraphicsWebDialogView(GraphicsRenderWidget parent, WebDialog dialog, com.teamdev.jxbrowser.ui.Rect initialBounds, double scaleFactor) {
        super((Composite)parent, 0);
        Preconditions.checkNotNull((Object)dialog);
        Preconditions.checkNotNull((Object)initialBounds);
        this.parent = parent;
        this.keyListener = new KeyListener();
        this.mouseListener = new MouseListener();
        this.mouseMoveListener = new MouseMotionListener();
        this.mouseTrackListener = new MouseTrackListener();
        this.mouseVerticalWheelListener = new MouseVerticalWheelListener();
        this.mouseHorizontalWheelListener = new MouseHorizontalWheelListener();
        dialog.set(PaintWebDialogCallback.class, (WebDialogCallback)((PaintWebDialogCallback)params -> {
            GraphicsWebDialogView graphicsWebDialogView = this;
            synchronized (graphicsWebDialogView) {
                PaintRequest request = params.getPaintRequest();
                com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
                Rect dirtyRect = request.getDirtyRect();
                if (!GraphicsWebDialogView.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                    return PaintDialog.Response.newBuilder().build();
                }
                int width = viewSize.width();
                int height = viewSize.height();
                long memoryId = request.getMemoryId().getValue();
                long windowHandle = NativeWindow.handle((Control)this);
                ToolkitLibrary library = ToolkitLibrary.instance();
                if (HiDpi.isPlatformDpiAware()) {
                    library.drawImage(windowHandle, width, height, memoryId);
                } else {
                    library.drawScaledImage(windowHandle, width, height, memoryId, (double)request.getScaleFactor());
                }
            }
            return PaintDialog.Response.newBuilder().build();
        }));
        SafeExecutor.asyncExec((Widget)this, () -> {
            if (!parent.nativeEventListener.isActive()) {
                this.addKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
            }
            this.addMouseListener((org.eclipse.swt.events.MouseListener)this.mouseListener);
            this.addMouseMoveListener(this.mouseMoveListener);
            this.addMouseTrackListener((org.eclipse.swt.events.MouseTrackListener)this.mouseTrackListener);
            this.addListener(37, this.mouseVerticalWheelListener);
            this.addListener(38, this.mouseHorizontalWheelListener);
            this.moveToTopCenter(initialBounds, scaleFactor);
        });
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    void moveToTopCenter(com.teamdev.jxbrowser.ui.Rect bounds, double scaleFactor) {
        int x = (int)((double)bounds.x() / scaleFactor);
        int width = (int)((double)bounds.width() / scaleFactor);
        int height = (int)((double)bounds.height() / scaleFactor);
        this.setBounds(x, 0, width, height);
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            GraphicsWebDialogView.this.parent.keyListener.keyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            GraphicsWebDialogView.this.parent.keyListener.keyReleased(e);
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseDown(MouseEvent event) {
            GraphicsWebDialogView.this.parent.mouseListener.mouseDown(event);
        }

        public void mouseUp(MouseEvent event) {
            GraphicsWebDialogView.this.parent.mouseListener.mouseUp(event);
        }
    }

    private class MouseMotionListener
    implements MouseMoveListener {
        private MouseMotionListener() {
        }

        public void mouseMove(MouseEvent e) {
            GraphicsWebDialogView.this.parent.mouseMoveListener.mouseMove(e);
        }
    }

    private class MouseTrackListener
    extends MouseTrackAdapter {
        private MouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            GraphicsWebDialogView.this.parent.mouseTrackListener.mouseEnter(event);
        }

        public void mouseExit(MouseEvent event) {
            GraphicsWebDialogView.this.parent.mouseTrackListener.mouseExit(event);
        }
    }

    private final class MouseVerticalWheelListener
    implements Listener {
        private MouseVerticalWheelListener() {
        }

        public void handleEvent(Event event) {
            GraphicsWebDialogView.this.parent.mouseVerticalWheelListener.handleEvent(event);
        }
    }

    private final class MouseHorizontalWheelListener
    implements Listener {
        private MouseHorizontalWheelListener() {
        }

        public void handleEvent(Event event) {
            GraphicsWebDialogView.this.parent.mouseHorizontalWheelListener.handleEvent(event);
        }
    }
}

