/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.PaintWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogSurface;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

final class IoSurfaceWebDialogView {
    private final NsView nsView;

    IoSurfaceWebDialogView(BrowserWidget widget, Composite parent, WebDialog dialog) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)dialog);
        this.nsView = new NsView(widget);
        if (dialog.browser().engine().options().renderingMode() == RenderingMode.OFF_SCREEN) {
            dialog.set(PaintWebDialogCallback.class, (WebDialogCallback)((PaintWebDialogCallback)params -> {
                PaintRequest request = params.getPaintRequest();
                this.nsView.updateSurface((Size)request.getViewSize(), request.getScaleFactor(), request.getMemoryId(), true);
                return PaintDialog.Response.newBuilder().build();
            }));
        } else {
            dialog.set(UpdateWebDialogSurfaceCallback.class, (WebDialogCallback)((UpdateWebDialogSurfaceCallback)params -> {
                this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor(), true);
                return UpdateDialogSurface.Response.newBuilder().build();
            }));
            dialog.set(UpdateWebDialogLayerCallback.class, (WebDialogCallback)((UpdateWebDialogLayerCallback)params -> {
                this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor(), true);
                return UpdateDialogLayer.Response.newBuilder().build();
            }));
        }
        dialog.on(DialogBoundsUpdated.class, event -> SafeExecutor.asyncExec((Widget)parent, () -> this.nsView.updateBounds((Rect)event.getBounds())));
        dialog.on(DialogClosed.class, event -> SafeExecutor.asyncExec((Widget)parent, () -> ((NsView)this.nsView).close()));
    }

    void show(long parentNsViewId, Rect boundsInPoints) {
        this.nsView.show(parentNsViewId, boundsInPoints);
    }
}

