/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.os.internal.OnScreenKeyboard;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.FocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.FocusCauseTracker;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareShell;
import com.teamdev.jxbrowser.view.swt.internal.Platform;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidgetBounds;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibrary;
import com.teamdev.jxbrowser.view.swt.internal.platform.NativeWindow;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class WindowedWidget
extends BrowserComposite
implements NativeAwareControl {
    private static final Set<WindowedWidget> displayedInstances = Collections.synchronizedSet(new HashSet());
    private final ControlListener controlListener;
    private final FocusAdapter focusAdapter;
    private final FocusCauseTracker focusCauseTracker;
    private final Subscription browserClosing;
    private final OnScreenKeyboard onScreenKeyboard;
    private Display currentDisplay;
    private State state = State.HIDDEN;

    WindowedWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, 0x1000000, widget);
        BrowserImpl browser = widget.browser();
        this.focusAdapter = FocusAdapter.newInstance(this);
        this.focusCauseTracker = new FocusCauseTracker(this);
        this.browserClosing = browser.on(BrowserClosing.class, event -> SafeExecutor.asyncExec((Widget)this, this::close));
        this.addDisposeListener(disposeEvent -> {
            this.hideRenderWidget();
            this.close();
        });
        this.currentDisplay = Display.primaryDisplay();
        this.controlListener = new ControlResizedListener();
        this.onScreenKeyboard = new OnScreenKeyboard(browser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImmutableSet<WindowedWidget> displayedWidgets() {
        Set<WindowedWidget> set = displayedInstances;
        synchronized (set) {
            return ImmutableSet.copyOf(displayedInstances);
        }
    }

    public BrowserView getParent() {
        return (BrowserView)super.getParent();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            SafeExecutor.asyncExec((Widget)this, this::showRenderWidget);
        } else {
            this.hideRenderWidget();
        }
    }

    void unfocusBrowserWidget() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.unfocus();
        }
    }

    void focusBrowserWidget() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.focus(this.focusCauseTracker.getFocusCause());
        }
    }

    @Override
    protected void close() {
        this.browserClosing.unsubscribe();
        this.unregisterListeners();
        super.close();
    }

    @Override
    void showRenderWidget() {
        if (this.state == State.SHOWING) {
            return;
        }
        Shell shell = this.getShell();
        this.displayWatcher().attach(new NativeAwareShell(shell));
        this.shellListeners().attach(shell);
        this.focusAdapter.startEventProcessing();
        this.focusCauseTracker.register();
        this.addControlListener(this.controlListener);
        this.attachWidget(this::onAttached, this::onAttachFailed);
        this.state = State.SHOWING;
        this.onScreenKeyboard.addNativeListeners(NativeWindow.handle((Control)shell));
    }

    @Override
    void notifyBoundsUpdated() {
        this.checkWidget();
        if (this.state != State.SHOWING) {
            return;
        }
        WindowedWidgetBounds bounds = WindowedWidgetBounds.calculateFor(this, this.currentDisplay.scaleFactor());
        this.browserWidget().bounds(bounds.inWindow(), bounds.inScreen());
    }

    private void attachWidget(Runnable onAttached, Runnable onFailed) {
        long componentHandle = this.nativeHandle();
        BrowserWidget widget = this.browserWidget();
        WindowedWidgetBounds bounds = WindowedWidgetBounds.calculateFor(this, this.currentDisplay.scaleFactor());
        Size initialSize = bounds.inWindow().size();
        if (Environment.isLinux()) {
            Optional chromiumXWindow = widget.chromiumWindowHandle();
            chromiumXWindow.ifPresent(windowHandle -> {
                GtkLibrary.instance().embedToSocket((Composite)this, windowHandle.getValue());
                widget.notifyParentWindowChanged(componentHandle, initialSize);
                onAttached.run();
            });
        } else {
            widget.attach(componentHandle, onAttached, onFailed, initialSize);
        }
    }

    private void onAttached() {
        SafeExecutor.asyncExec((Widget)this, () -> {
            if (this.isVisible()) {
                this.browserWidget().show();
                displayedInstances.add(this);
                this.notifyBoundsUpdated();
            }
        });
    }

    private void onAttachFailed() {
        SafeExecutor.asyncExec((Widget)this, this::close);
    }

    @Override
    void hideRenderWidget() {
        if (this.state == State.HIDDEN) {
            return;
        }
        this.unregisterListeners();
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.hide();
        }
        this.state = State.HIDDEN;
        this.onScreenKeyboard.removeNativeListeners(NativeWindow.handle((Control)this.getShell()));
    }

    private void unregisterListeners() {
        displayedInstances.remove(this);
        this.focusAdapter.stopEventProcessing();
        this.focusCauseTracker.unregister();
        this.displayWatcher().detach();
        this.shellListeners().detach();
        this.removeControlListener(this.controlListener);
    }

    @Override
    protected void onMovedToDisplay(Display osDisplay) {
        super.onMovedToDisplay(osDisplay);
        if (Platform.hasImprovedDpiSupport()) {
            this.currentDisplay = osDisplay;
        }
        this.notifyBoundsUpdated();
    }

    @Override
    public void enableDragAndDrop() {
    }

    @Override
    public void disableDragAndDrop() {
    }

    @Override
    public void setEnabledExternalDrag(boolean enabled) {
    }

    private static enum State {
        SHOWING,
        HIDDEN;

    }

    private class ControlResizedListener
    extends ControlAdapter {
        private ControlResizedListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }
}

