/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.view.swt.internal.FocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidget;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Event;

final class WindowsFocusAdapter
extends FocusAdapter {
    private final AtomicBoolean isChromiumFocused = new AtomicBoolean();

    WindowsFocusAdapter(WindowedWidget jxComposite) {
        super(jxComposite);
    }

    @Override
    protected void on(FocusLost event) {
        this.isChromiumFocused.set(false);
    }

    @Override
    protected void on(FocusGained event) {
        this.isChromiumFocused.set(true);
        this.unfocusOthers();
    }

    @Override
    protected void onSwtWidgetFocusedIn(Event event) {
        WindowedWidget jxComposite = this.windowedWidget();
        boolean browserIsTarget = event.widget.equals(jxComposite);
        boolean isChromiumFocused = this.isChromiumFocused.get();
        if (browserIsTarget && !isChromiumFocused) {
            jxComposite.focusBrowserWidget();
        } else if (!browserIsTarget && isChromiumFocused) {
            jxComposite.unfocusBrowserWidget();
        }
    }

    private void unfocusOthers() {
        WindowedWidget jxComposite = this.windowedWidget();
        for (WindowedWidget displayedWidget : WindowedWidget.displayedWidgets()) {
            if (displayedWidget.equals(jxComposite)) continue;
            displayedWidget.unfocusBrowserWidget();
        }
    }
}

