/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragLifecycleEvents;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DropTargetEvents;

public final class DragAndDropSupport {
    static final int SUPPORTED_OPERATIONS = 15;
    private final BrowserDragContext context = BrowserDragContext.newInstance();
    private final DropTargetEvents dropTargetEvents;
    private final DragLifecycleEvents dragLifecycleEvents;
    private State state;

    public static DragAndDropSupport newInstance(OffScreenRenderWidget composite) {
        Preconditions.checkNotNull((Object)composite);
        return new DragAndDropSupport(composite);
    }

    private DragAndDropSupport(OffScreenRenderWidget composite) {
        this.dragLifecycleEvents = DragLifecycleEvents.newInstance(composite, this.context);
        this.dropTargetEvents = DropTargetEvents.newInstance(composite, this.context);
        this.state = State.DISABLED;
    }

    public void enable() {
        if (this.state == State.ENABLED) {
            return;
        }
        this.dragLifecycleEvents.startForwarding();
        this.dropTargetEvents.startForwarding();
        this.state = State.ENABLED;
    }

    public void disable() {
        if (this.state == State.DISABLED) {
            return;
        }
        this.dropTargetEvents.stopForwarding();
        this.dragLifecycleEvents.stopForwarding();
        this.state = State.DISABLED;
    }

    public boolean isBrowserDragHappening() {
        return this.context.browserDragOperation().isPresent();
    }

    public BrowserDragContext context() {
        return this.context;
    }

    private static enum State {
        ENABLED,
        DISABLED;

    }
}

