/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.os.Environment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;

public final class ComponentLocator {
    public static Point locationOnScreen(Component component) {
        return component.isShowing() ? component.getLocationOnScreen() : new Point();
    }

    private ComponentLocator() {
    }

    static Point locationInWindow(Component component) {
        if (!component.isShowing()) {
            return new Point();
        }
        Point locationOnScreen = component.getLocationOnScreen();
        Container parent = component.getParent();
        if (parent == null) {
            return new Point();
        }
        Container container = ComponentLocator.getTopLevelContainer(parent);
        Point windowLocationOnScreen = container.getLocationOnScreen();
        int x = locationOnScreen.x - windowLocationOnScreen.x;
        int y = locationOnScreen.y - windowLocationOnScreen.y;
        if (Environment.isMac()) {
            y = container.getHeight() - component.getHeight() - y;
        }
        return new Point(x, y);
    }

    private static Container getTopLevelContainer(Container container) {
        Container parent = container.getParent();
        if (parent == null || parent instanceof Window) {
            return container;
        }
        return ComponentLocator.getTopLevelContainer(parent);
    }
}

