/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragOperations;
import com.teamdev.jxbrowser.view.swing.internal.dnd.FileListDataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.HtmlDataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.TextDataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.UrlDataType;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

final class DragMouseEvents
extends DropTargetAdapter {
    private final BrowserDragContext context;
    private final DropTarget dropTarget;
    private final OffScreenRenderWidget component;
    private final List<DataType> dataTypes;
    private Subscription dragCursorUpdated;
    private DragOperation cursor;

    static DragMouseEvents newInstance(OffScreenRenderWidget component, BrowserDragContext context) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)context);
        return new DragMouseEvents(component, context);
    }

    private DragMouseEvents(OffScreenRenderWidget component, BrowserDragContext context) {
        this.component = component;
        this.context = context;
        this.dropTarget = new DropTarget(null, this);
        this.cursor = DragOperation.OPERATION_NONE;
        this.dataTypes = ImmutableList.of((Object)new TextDataType(), (Object)new UrlDataType(), (Object)new HtmlDataType(), (Object)new FileListDataType(), (Object)new CustomDataType());
    }

    void startForwarding() {
        this.dropTarget.setComponent(this.component);
        this.dragCursorUpdated = this.component.widget().on(DragCursorUpdated.class, event -> {
            this.cursor = event.getDragOperation();
        });
    }

    void stopForwarding() {
        this.dropTarget.setComponent(null);
        this.dragCursorUpdated.unsubscribe();
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (this.shouldRejectExternalDrag() || !this.isSupportedData(event.getTransferable())) {
            event.rejectDrag();
            return;
        }
        Point location = ToolkitConverters.toProtoPoint(event.getLocation());
        Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(this.component));
        Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
        DropMetadata dropMetadata = this.fillMetadata(event.getTransferable());
        int operationsAllowed = DragOperations.toDragOperationMask(event.getSourceActions());
        KeyModifiers keyModifiers = this.keyModifiers(event.getDropAction());
        this.widget().dragEnter(dropMetadata, location, screenLocation, operationsAllowed, keyModifiers);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (!this.isSupportedData(event.getTransferable())) {
            event.rejectDrag();
            return;
        }
        this.acceptOrReject(event);
        Point location = ToolkitConverters.toProtoPoint(event.getLocation());
        Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(this.component));
        Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
        int operationsAllowed = DragOperations.toDragOperationMask(event.getSourceActions());
        KeyModifiers keyModifiers = this.keyModifiers(event.getDropAction());
        this.widget().dragOver(location, screenLocation, operationsAllowed, keyModifiers);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.widget().dragLeave();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        Point location = ToolkitConverters.toProtoPoint(event.getLocation());
        Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(this.component));
        Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
        event.acceptDrop(event.getDropAction());
        DropData dropData = this.readData(event.getTransferable());
        KeyModifiers keyModifiers = this.keyModifiers(event.getDropAction());
        this.widget().drop(dropData, location, screenLocation, keyModifiers);
        event.dropComplete(true);
    }

    private boolean shouldRejectExternalDrag() {
        return !this.context.isBrowserDragHappening() && !this.context.isExternalDragEnabled();
    }

    private void handleSpecialCases(DropData.Builder builder) {
        if (builder.getUrl().isEmpty() && DragMouseEvents.isDataUrl(builder.getText())) {
            builder.setUrl(builder.getText());
        }
        if (builder.getText().isEmpty()) {
            builder.setText(builder.getUrl());
        }
    }

    private static boolean isDataUrl(String text) {
        return text.startsWith("data:");
    }

    private boolean isSupportedData(Transferable transferable) {
        if (this.isEmpty(transferable)) {
            return true;
        }
        return this.dataTypes.stream().anyMatch(dataType -> dataType.isPresentedIn(transferable));
    }

    private DropMetadata fillMetadata(Transferable transferable) {
        DropMetadata.Builder metaData = DropMetadata.newBuilder();
        this.dataTypes.forEach(dataType -> dataType.fillMetadata(transferable, metaData));
        return metaData.build();
    }

    private DropData readData(Transferable transferable) {
        DropData.Builder dropData = DropData.newBuilder();
        this.dataTypes.forEach(dataType -> {
            try {
                dataType.fillDropData(transferable, dropData);
            }
            catch (RuntimeException e) {
                Logger.debug((String)"Failed to read data from drag-n-drop.", (Throwable)e);
            }
        });
        this.handleSpecialCases(dropData);
        return dropData.build();
    }

    private boolean isEmpty(Transferable transferable) {
        return transferable.getTransferDataFlavors().length == 0;
    }

    private void acceptOrReject(DropTargetDragEvent event) {
        if (this.cursor == DragOperation.OPERATION_NONE) {
            event.rejectDrag();
        } else {
            event.acceptDrag(this.toAwtOperation(this.cursor));
        }
    }

    private Integer toAwtOperation(DragOperation operation) {
        return DragOperations.convert(operation);
    }

    private BrowserWidget widget() {
        return this.component.widget();
    }

    private KeyModifiers keyModifiers(int operation) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder();
        return switch (operation) {
            case 2 -> {
                if (Environment.isMac()) {
                    yield builder.setMetaDown(true).build();
                }
                yield builder.setShiftDown(true).build();
            }
            case 1 -> {
                if (Environment.isMac()) {
                    yield builder.setAltDown(true).build();
                }
                yield builder.setControlDown(true).build();
            }
            case 0x40000000 -> {
                if (Environment.isMac()) {
                    yield builder.setAltDown(true).setMetaDown(true).build();
                }
                yield builder.setControlDown(true).setShiftDown(true).build();
            }
            default -> builder.build();
        };
    }
}

