/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.Optional;

final class MacOsCompatibility {
    static final DataFlavor SERIALIZED_URL_FLAVOR = new DataFlavor(byte[].class, "Serialized URL");

    private MacOsCompatibility() {
    }

    static void configureFlavorMap() {
        Preconditions.checkState((boolean)Environment.isMac());
        SystemFlavorMap flavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        flavorMap.setNativesForFlavor(SERIALIZED_URL_FLAVOR, new String[]{"URL"});
    }

    static Optional<String> readUrlFromPasteboard() {
        Preconditions.checkState((boolean)Environment.isMac());
        String url = MacPasteboard.instance().readUrl();
        return Optional.ofNullable(url);
    }

    static byte[] serializeUrlForPasteboard(String url) {
        Preconditions.checkState((boolean)Environment.isMac());
        return MacPasteboard.instance().serializeUrl(url);
    }
}

