/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.base.Splitter;
import java.awt.datatransfer.DataFlavor;
import java.util.List;

final class MimeType {
    private final String primaryType;
    private final String subType;

    static MimeType newInstance(String mimeType) {
        List chunks = Splitter.on((char)'/').splitToList((CharSequence)mimeType);
        Preconditions.checkArgument((chunks.size() == 2 ? 1 : 0) != 0);
        return new MimeType((String)chunks.get(0), (String)chunks.get(1));
    }

    private MimeType(String primaryType, String subType) {
        Preconditions.checkNotNull((Object)primaryType);
        Preconditions.checkNotNull((Object)subType);
        this.primaryType = primaryType;
        this.subType = subType;
    }

    boolean matches(DataFlavor flavor) {
        boolean samePrimaryType = this.primaryType.equals(flavor.getPrimaryType());
        boolean sameSubType = this.subType.equals(flavor.getSubType());
        return samePrimaryType && sameSubType;
    }
}

