/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.menu.ContextMenuItem;
import com.teamdev.jxbrowser.menu.ContextMenuItemType;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.internal.menu.ContextMenu;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class DefaultContextMenu
extends ContextMenu {
    public DefaultContextMenu(BrowserView parent, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        super(parent, params, callback);
    }

    @Override
    protected void initialize(JPopupMenu popupMenu) {
        for (ContextMenuItem item : this.params().extensionMenuItems()) {
            if (item.type() == ContextMenuItemType.SEPARATOR) {
                popupMenu.addSeparator();
                continue;
            }
            popupMenu.add(this.createMenuItem(item));
        }
    }

    private JMenuItem createMenuItem(ContextMenuItem menuItem) {
        ContextMenuItemType type = menuItem.type();
        if (type == ContextMenuItemType.ITEM) {
            return this.createSimpleMenuItem(menuItem);
        }
        if (type == ContextMenuItemType.CHECKABLE_ITEM) {
            return this.createCheckedMenuItem(menuItem);
        }
        if (type == ContextMenuItemType.SUB_MENU) {
            return this.createSubMenu(menuItem);
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    private JMenu createSubMenu(ContextMenuItem item) {
        JMenu result = new JMenu(item.text());
        for (ContextMenuItem contextMenuItem : item.items()) {
            if (contextMenuItem.type() == ContextMenuItemType.SEPARATOR) {
                result.addSeparator();
                continue;
            }
            result.add(this.createMenuItem(contextMenuItem));
        }
        return result;
    }

    private JMenuItem createSimpleMenuItem(ContextMenuItem item) {
        JMenuItem result = new JMenuItem(item.text());
        result.setEnabled(item.isEnabled());
        result.addActionListener(e -> this.callback().select(item));
        return result;
    }

    private JMenuItem createCheckedMenuItem(ContextMenuItem item) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(item.text(), item.isChecked());
        result.setEnabled(item.isEnabled());
        result.addActionListener(e -> this.callback().select(item));
        return result;
    }
}

