/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback.internal;

import com.teamdev.jxbrowser.browser.callback.BrowserSyncCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.ShowTextReplacementMenu;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.ui.Rect;

public interface ShowTextReplacementMenuCallback
extends BrowserSyncCallback<ShowTextReplacementMenu.Request, Response> {

    public static interface Response {
        public static Response select(String text) {
            if (text.isEmpty() || text.isBlank()) {
                return Response.dismiss();
            }
            return ShowTextReplacementMenu.Response.newBuilder().setText(text).build();
        }

        public static Response dismiss() {
            return ShowTextReplacementMenu.Response.newBuilder().setEmpty(Empty.newBuilder().build()).build();
        }
    }

    public static interface Params {
        default public String primaryString() {
            return ((ShowTextReplacementMenu.Request)this).getPrimaryString();
        }

        default public Rect occludedRect() {
            return ((ShowTextReplacementMenu.Request)this).getOccludedRect();
        }

        default public ImmutableList<String> suggestions() {
            return ((ShowTextReplacementMenu.Request)this).getAlternativeStringsList().stream().collect(ImmutableList.toImmutableList());
        }
    }
}

