/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.UnsupportedRenderingModeException;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.internal.linux.AtkObject;
import com.teamdev.jxbrowser.view.internal.mac.NsAccessibility;
import com.teamdev.jxbrowser.view.internal.win.IAccessible;

public abstract class AccessibilityNode {
    public static AccessibilityNode create(BrowserWidget browserWidget) {
        Preconditions.checkNotNull(browserWidget);
        RenderingMode renderingMode = browserWidget.browser().engine().options().renderingMode();
        if (Environment.isMac()) {
            return new NsAccessibility(browserWidget);
        }
        if (Environment.isWindows() && renderingMode == RenderingMode.OFF_SCREEN) {
            return new IAccessible(browserWidget);
        }
        if (Environment.isLinux() && renderingMode == RenderingMode.OFF_SCREEN) {
            return new AtkObject();
        }
        throw new UnsupportedRenderingModeException(renderingMode);
    }

    public abstract void add(long var1, long var3);

    public abstract void remove();
}

