/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.card.internal;

import com.teamdev.jxbrowser.card.CreditCard;
import com.teamdev.jxbrowser.card.CreditCards;
import com.teamdev.jxbrowser.card.internal.rpc.AddCreditCardRequest;
import com.teamdev.jxbrowser.card.internal.rpc.CreditCardList;
import com.teamdev.jxbrowser.card.internal.rpc.CreditCardsStub;
import com.teamdev.jxbrowser.card.internal.rpc.RemoveCreditCardRequest;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.List;

public final class CreditCardsImpl
extends CloseableImpl
implements CreditCards {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<CreditCardsStub> rpc;

    public CreditCardsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        Connection connection = profile.engine().connection();
        this.rpc = new ServiceConnectionImpl<CreditCardsStub>(profile.id(), connection, CreditCardsStub::new);
    }

    @Override
    public void add(CreditCard creditCard) {
        this.checkNotClosed();
        Preconditions.checkNotNull(creditCard);
        AddCreditCardRequest newRequest = AddCreditCardRequest.newBuilder().setCreditCard(com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(creditCard)).setProfileId(this.profile.id()).build();
        String error = ((StringValue)this.rpc.invoke(this.rpc.stub()::addCreditCard, newRequest)).getValue();
        if (!error.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public List<CreditCard> all() {
        this.checkNotClosed();
        return ((CreditCardList)this.rpc.invoke(this.rpc.stub()::getAllCreditCards, this.profile.id())).getRecordList().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public void remove(CreditCard creditCard) {
        this.checkNotClosed();
        RemoveCreditCardRequest request = this.removeRecordRequest(((com.teamdev.jxbrowser.card.internal.rpc.CreditCard)creditCard).getGuid());
        this.rpc.invoke(this.rpc.stub()::removeCreditCard, request);
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::clear, this.profile.id());
    }

    private RemoveCreditCardRequest removeRecordRequest(String guid) {
        return RemoveCreditCardRequest.newBuilder().setProfileId(this.profile.id()).setGuid(guid).build();
    }
}

