/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.MediaCasting;
import com.teamdev.jxbrowser.cast.Screens;
import com.teamdev.jxbrowser.cast.internal.CastSessionsImpl;
import com.teamdev.jxbrowser.cast.internal.MediaReceiversImpl;
import com.teamdev.jxbrowser.cast.internal.ScreensImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class MediaCastingImpl
extends CloseableImpl
implements MediaCasting {
    public static final String MEDIA_ROUTER_FEATURE = "MediaRouter";
    private final CastSessionsImpl castSessions;
    private final MediaReceiversImpl receivers;
    private final ScreensImpl screens;
    private final ProfileImpl profile;

    public MediaCastingImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.castSessions = new CastSessionsImpl(profile);
        this.receivers = new MediaReceiversImpl(profile);
        this.screens = new ScreensImpl(profile);
        this.init();
    }

    private void init() {
        this.castSessions.startObserving();
        this.receivers.startDiscovering();
    }

    @Override
    public CastSessionsImpl castSessions() {
        return this.castSessions;
    }

    @Override
    public MediaReceiversImpl mediaReceivers() {
        return this.receivers;
    }

    @Override
    public Screens screens() {
        return this.screens;
    }

    @Override
    public void close() {
        super.close();
        this.screens.close();
        this.receivers.close();
        this.castSessions.close();
    }

    @Override
    public Profile profile() {
        return this.profile;
    }
}

