/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cookie;

import com.teamdev.jxbrowser.cookie.PartitionKey;
import com.teamdev.jxbrowser.cookie.internal.rpc.Cookie;
import com.teamdev.jxbrowser.cookie.internal.rpc.SameSite;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.time.Timestamp;
import java.util.Optional;

public interface Cookie {
    public static Builder newBuilder(String domain) {
        StringPreconditions.checkNotNullEmptyOrBlank(domain);
        return new Builder(domain);
    }

    default public String name() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getName();
    }

    default public String value() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getValue();
    }

    default public String domain() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getDomain();
    }

    default public String path() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getPath();
    }

    default public boolean isSecure() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getSecure();
    }

    default public boolean isHttpOnly() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getHttpOnly();
    }

    default public Timestamp creationTime() {
        return com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this).getCreationTime();
    }

    default public Timestamp expirationTime() {
        com.teamdev.jxbrowser.cookie.internal.rpc.Cookie rawCookie = com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this);
        if (rawCookie.hasExpirationTime()) {
            return rawCookie.getExpirationTime();
        }
        return Timestamp.NONE;
    }

    default public com.teamdev.jxbrowser.cookie.SameSite sameSite() {
        com.teamdev.jxbrowser.cookie.internal.rpc.Cookie rawCookie = com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this);
        return rawCookie.getSameSite().toPublic();
    }

    default public Optional<PartitionKey> partitionKey() {
        com.teamdev.jxbrowser.cookie.internal.rpc.Cookie rawCookie = com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.cast(this);
        if (rawCookie.hasPartitionKey()) {
            return Optional.of(rawCookie.getPartitionKey());
        }
        return Optional.empty();
    }

    public static final class Builder {
        private final Cookie.Builder builder = com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.newBuilder();

        private Builder(String domain) {
            this.builder.setDomain(domain);
            this.creationTime(Timestamp.fromMillis(System.currentTimeMillis()));
            this.sameSite(com.teamdev.jxbrowser.cookie.SameSite.LAX_MODE);
        }

        public Builder name(String name) {
            Preconditions.checkNotNull(name);
            this.builder.setName(name);
            return this;
        }

        public Builder value(String value) {
            Preconditions.checkNotNull(value);
            this.builder.setValue(value);
            return this;
        }

        public Builder path(String path) {
            Preconditions.checkNotNull(path);
            this.builder.setPath(path);
            return this;
        }

        public Builder secure(boolean secure) {
            this.builder.setSecure(secure);
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.builder.setHttpOnly(httpOnly);
            return this;
        }

        public Builder creationTime(Timestamp creationTime) {
            Preconditions.checkNotNull(creationTime);
            this.builder.setCreationTime((com.teamdev.jxbrowser.time.internal.rpc.Timestamp)creationTime);
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            Preconditions.checkNotNull(expirationTime);
            this.builder.setExpirationTime((com.teamdev.jxbrowser.time.internal.rpc.Timestamp)expirationTime);
            return this;
        }

        public Builder sameSite(com.teamdev.jxbrowser.cookie.SameSite sameSite) {
            Preconditions.checkNotNull(sameSite);
            this.builder.setSameSite(SameSite.fromPublic(sameSite));
            return this;
        }

        public Cookie build() {
            return this.builder.build();
        }
    }
}

