/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.base;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    private Joiner(String separator) {
        this.separator = Preconditions.checkNotNull(separator);
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A appendable, Iterator<?> parts) throws IOException {
        Preconditions.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder, Iterator<?> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public String join(Iterable<?> parts) {
        if (parts instanceof List) {
            int size = ((List)parts).size();
            if (size == 0) {
                return "";
            }
            CharSequence[] toJoin = new CharSequence[size];
            int i = 0;
            for (Object part : parts) {
                if (i == toJoin.length) {
                    toJoin = Arrays.copyOf(toJoin, Joiner.expandedCapacity(toJoin.length, toJoin.length + 1));
                }
                toJoin[i++] = this.toString(part);
            }
            if (i != toJoin.length) {
                toJoin = Arrays.copyOf(toJoin, i);
            }
            return String.join((CharSequence)this.separator, toJoin);
        }
        return this.join(parts.iterator());
    }

    public final String join(Iterator<?> parts) {
        return this.appendTo(new StringBuilder(), parts).toString();
    }

    public final String join(@Nullable Object[] parts) {
        List<Object> partsList = Arrays.asList(parts);
        return this.join(partsList);
    }

    CharSequence toString(@Nullable Object part) {
        Objects.requireNonNull(part);
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }

    private static int expandedCapacity(int oldCapacity, int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalArgumentException("cannot store more than Integer.MAX_VALUE elements");
        }
        if (minCapacity <= oldCapacity) {
            return oldCapacity;
        }
        int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
        if (newCapacity < minCapacity) {
            newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
        }
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        return newCapacity;
    }
}

