/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.base;

import com.teamdev.jxbrowser.deps.com.google.common.base.CommonPattern;
import com.teamdev.jxbrowser.deps.com.google.common.base.JdkPattern;
import com.teamdev.jxbrowser.deps.com.google.common.base.PatternCompiler;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.base.Strings;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

final class Platform {
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    static String lenientFormat(@Nullable String template, Object ... args) {
        return Strings.lenientFormat(template, args);
    }

    static String stringValueOf(@Nullable Object o) {
        return String.valueOf(o);
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile(pattern));
        }
    }
}

