/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.event;

import com.teamdev.jxbrowser.internal.string.StringPreconditions;

public interface EventType {
    public static final EventType CLICK = EventType.of("click");
    public static final EventType DOUBLE_CLICK = EventType.of("dblclick");
    public static final EventType MOUSE_DOWN = EventType.of("mousedown");
    public static final EventType MOUSE_UP = EventType.of("mouseup");
    public static final EventType MOUSE_OVER = EventType.of("mouseover");
    public static final EventType MOUSE_MOVE = EventType.of("mousemove");
    public static final EventType MOUSE_ENTER = EventType.of("mouseenter");
    public static final EventType MOUSE_OUT = EventType.of("mouseout");
    public static final EventType WHEEL = EventType.of("wheel");
    public static final EventType KEY_DOWN = EventType.of("keydown");
    public static final EventType KEY_UP = EventType.of("keyup");
    public static final EventType KEY_PRESS = EventType.of("keypress");
    public static final EventType LOAD = EventType.of("load");
    public static final EventType UNLOAD = EventType.of("unload");
    public static final EventType ABORT = EventType.of("abort");
    public static final EventType ERROR = EventType.of("error");
    public static final EventType RESIZE = EventType.of("resize");
    public static final EventType SCROLL = EventType.of("scroll");
    public static final EventType SELECT = EventType.of("select");
    public static final EventType CHANGE = EventType.of("change");
    public static final EventType SUBMIT = EventType.of("submit");
    public static final EventType RESET = EventType.of("reset");
    public static final EventType FOCUS = EventType.of("focus");
    public static final EventType BLUR = EventType.of("blur");
    public static final EventType TOUCH_MOVE = EventType.of("touchmove");
    public static final EventType TOUCH_CANCEL = EventType.of("touchcancel");
    public static final EventType TOUCH_START = EventType.of("touchstart");
    public static final EventType TOUCH_END = EventType.of("touchend");

    public static EventType of(String eventName) {
        StringPreconditions.checkNotNullEmptyOrBlank(eventName);
        return com.teamdev.jxbrowser.dom.event.internal.rpc.EventType.newBuilder().setValue(eventName).build();
    }

    default public String value() {
        return ((com.teamdev.jxbrowser.dom.event.internal.rpc.EventType)this).getValue();
    }
}

